class GuildConsignment < ActiveRecord::Base
  belongs_to :user
  belongs_to :item

  # ֤˰ܰĤˤĤʿѿͿ
  GUEST_PER_HOUR = 2
  # 褿Ҥκ
  GUEST_MONEY_LIMIT = 100

  def self.make_consignment( user, item, amount, price )
    msg = ""
    if user.location.has_guild?
      if (s = Stock.find_by_user_id_and_item_id( user.id, item.id ))
        if s.stock >= amount
          transaction do
            self.create!( :user_id => user.id,
                          :item_id => item.id,
                          :stock => amount,
                          :price => price
                          )
            s.stock -= amount
            s.save!
          end
          return "#{item.item_name}ñ#{price}#{amount}ñ̰ޤ"
        else
          raise "Ѵ˾­ޤ"
          return msg
        end
      else
        raise "򤷤ƥबǤ"
        return msg
      end
    else
      raise "ˤϥɻޤ"
      return msg
    end
  end

  def cancel_consignment( user )
    raise "ʬΰǤϤޤ" if user.id != user_id
    s = Stock.find_or_create_by_user_id_and_item_id( user_id, item_id )
    if s
      transaction do
        s.stock += self.stock
        s.save
        self.destroy
      end
      true
    else
      raise "桼ƥॹȥåμ˼Ԥޤ"
      false
    end
  end

  def npc_buy(amount)
    o = User.find( self.user_id )
    total = self.price * amount
    transaction do
      self.stock -= amount
      self.save
      o.income( total )
      o.save
      if self.stock == 0
        o.sendMessage( nil, "ʬڤ", "Ƥ#{self.item.item_name}ڤޤ" )
        self.destroy
      end
      logger.info("npc buy : #{self.item.item_name} x #{amount}, price = #{total}.") if logger.info?
    end # transaction
  end

  def self.rand_poisson(avg)
    x = 0
    v = 1.0
    vlim = Math.exp(-avg)
    loop do
      v *= rand
      break if v < vlim
      x += 1
    end
    return x
  end

  def self.npc_buy_consignments
    self.find(:all, :conditions => ['stock > 0'] ).each do |c|
      self.rand_poisson(GUEST_PER_HOUR * 5.0 / 60).times do |i|
        item = Item.find( c.item_id )
        break if GUEST_MONEY_LIMIT < c.price
        rate = c.price.to_f / item.rate_price
        percent = get_buy_percentage( rate )
        if rand(100) < percent
          amount = get_buy_amount( rate )
          if amount * c.price > GUEST_MONEY_LIMIT
            amount = GUEST_MONEY_LIMIT / c.price
          end
          amount = c.stock if c.stock < amount
          c.npc_buy( amount )
        end
      end
    end
  end

  def self.get_buy_percentage( rate )
    ret = 0
    if rate <= 1
      # Τޤް̤ 0.6-1
      ret = 0.6 + 0.4 * (1 - rate)
    else
      # տˤ 0-0.6
      ret = 1.0 / rate * 0.6
    end
    return ret * 100
  end

  def self.get_buy_amount( rate )
    ret = 1
    ret = rand_poisson( 1.0 / rate )
    return ret
  end
end
