class MoveController < ApplicationController
  KEY_NUMBER_MAX = 2048000000

  def initialize
    @title = 'ư'
  end

  def list_neighbors
    count = 0
    @locs = Location.find_all_by_parent_id( @user.location.id )
    while @locs.size < 1 && @user.user_location != 1 && count < 10
      @user.user_location = @user.location.parent_id
      @user.save
      @user.reload
      @locs = Location.find_all_by_parent_id( @user.location.id )
      count += 1
    end
    render :action => 'list'
  end

  def list
    @locs = Location.find_all_by_parent_id( @user.location.id )
  end

  def go
    if params[:dest].to_i > 0
      @user.user_location = params[:dest].to_i
      @user.save
    end
    list
    render :action => 'list'
  end

  def pick_game_select
    @title = "ν"
    if params[:keynumber] && params[:keynumber].size > 0
      kn = params[:keynumber].to_i(16)
      if kn > KEY_NUMBER_MAX || kn < 0
        flash.now[:error] = "ꤷɤ̵ͤǤ"
        session[:keynumber] = nil
      else
        session[:keynumber] = kn
      end
    end
    pick_game
  end

  def pick_game
    if LocationPick.count( :conditions => [ "location_id = ?",@user.location.id] ) < 1
      # Τʤ
      @title = 'ν'
      @busket = []
      render :action => 'pick'
      return
    end

    session[:keynumber] = rand(KEY_NUMBER_MAX) unless session[:keynumber]
    @keynumber = session[:keynumber]
    @title = "ν@#{@user.location.location_name}(#{@keynumber.to_s(16)})"
    @background = get_background_filename(@keynumber)
    @point_file = "images/clear.png"
    render 'move/pick_game'
  end

  def pick
    @title = 'ν'
    @keynumber = session[:keynumber]
    unless PickRestriction.can_pick_here?( @user, @keynumber )
      flash.now[:error] = "Ʊɤϰ֡ѤǤޤ"
      session[:keynumber] = nil
      pick_game
      return
    end
    unless params[:click] || params[:click].to_i < 1
      flash.now[:error] = "å֤Ǥ"
      pick_game
      return
    else
      srand( @keynumber )
      params[:click].to_i.times{|i| rand() }
      seed = rand(KEY_NUMBER_MAX)

      srand( seed )
      @busket = []
      picks = LocationPick.find_all_by_location_id( @user.location.id )
      picks.each do |pick|
        ret = pick_challenge( @user, pick )
        @busket << ret if ret
      end
    end
  end

  private
  def get_background_filename(key)
    "images/bg.png"
  end
  def pick_challenge( user, pick )
    count = 0
    pick.challenge.times do
      count += 1 if rand(1000) < pick.permill
    end
    count = pick.stock if count > pick.stock
    ret = pick_item( user, pick, count ) if count > 0
    return ret
  end
  def pick_item(user, pick, count)
    ret = nil
    diff = count
    user.get_item( pick.item_id, count ) do |stock, num|
      diff = (stock.stock + num > Stock::MAX_STOCK ?
              Stock::MAX_STOCK - stock.stock :
              num)
      diff
    end
    if diff > 0
      pick.stock -= diff
      pick.save
      ret = [ pick.item, diff ]
    end
    ret
  end
end
