class GuildController < ApplicationController
  DEADLINE_INTERVAL_MAX = 48

  def list
    init
    @title = "ɡ" + @sibu
  end

  def order_list
    init
    @title = "ꥹ " + @sibu
    @orders = GuildOrder.find(:all, :conditions => ['location_id = ? AND done != TRUE AND worker_id IS NULL AND (owner_id != ? OR owner_id IS NULL) AND (deadline > ? OR deadline IS NULL)', @user.location.id, @user.id, Time.now ] )
  end

  def contract
    init
    if params[:order_id] && (@order = GuildOrder.find( params[:order_id].to_i ))

      if params[:confirm]
        @result = GuildOrder.contract( session[:user_id], @order.id )
        render 'guild/contract_order'
      else
        render 'guild/contract_order_confirm'
      end
    else
      flash.now[:error] = "꤬ǤޤǤ" if params[:order_id]
      render 'guild/list'
    end
  end

  def close_order
    init
    @title = "δλ"
    fun = lambda{|o| Stock::amount( @user.id, o.item_id ) >= o.amount }
    if params[:order_id] && (@order = GuildOrder.find( params[:order_id].to_i ))
      if @order.amount <= Stock::amount( @user.id, @order.item_id )
        if params[:confirm]
          @result = GuildOrder.close_order( @user, @order )
          render 'guild/close_order'
        else
          render 'guild/confirm_close'
        end
      else
        flash.now[:error] = "Υƥब­ޤ"
        render_my_order_list 'close_order', 'λ', &fun
      end
    else
      flash.now[:error] = "Ǥޤ" if params[:order_id]
      render_my_order_list 'close_order', 'λ', &fun
    end
  end

  def abort_order
    init
    @title = ""
    if params[:order_id] && (@order = GuildOrder.find( params[:order_id].to_i ))
      if params[:confirm]
        GuildOrder.abort_order( @user, @order )
      else
        render 'guild/abort_confirm'
      end
    else
      flash.now[:error] = "Ǥޤ" if params[:order_id]
      render_my_order_list 'abort_order', ''
    end
  end

  def make_order_confirm
    init
    if params[:item_id] and params[:amount] and params[:price] and params[:deadline_interval]
      @title = " " + @sibu
      @item_id = params[:item_id].to_i
      @amount = params[:amount].to_i
      @price = params[:price].to_i
      @item = Item.find( @item_id )
      @deadline_interval = params[:deadline_interval].to_i
      if @amount <= 0 or @price <= 0
        flash.now[:error] = "̤󽷤 0 礭Ƥ"
        render 'guild/make_order'
      elsif @amount > GuildOrder::OrderAmountMax
        flash.now[:info] = "̤#{GuildOrder::OrderAmountMax}ޤǤǤ"
        render 'guild/make_order'
      elsif @price > @user.user_money
        flash.now[:error] = "󽷤ʧޤ"
        render 'guild/make_order'
      elsif @deadline_interval < 0 || @deadline_interval > DEADLINE_INTERVAL_MAX
        flash.now[:error] = "ڻ֤Ǥ"
        render 'guild/make_order'
      else
        begin
          @deadline = (Time.now + @deadline_interval * 3600).strftime("%Y-%m-%d %H:%M")
          @result = GuildOrder.make_order( @user, @item, @amount, @price, @deadline_interval )
        rescue => e
          @result = nil
          flash.now[:error] = e.message
          params[:item_id] = nil
          make_order
        end
      end
    else
      params[:item_id] = nil
      flash.now[:error] = "ɬפʾ­ޤ"
      make_order
    end
  end

  def make_order
    init
    if params[:item_id]
      @title = ''
      @item = Item.find( params[:item_id].to_i )
      @interval_opts = []
      @interval_opts << ['¤ʤ', 0]
      (1..48).each do |i|
        @interval_opts << ["#{i}ָ", i]
      end
    else
      @title = 'ꤹ ' + @sibu
      @stocks = Stock.find_all_by_user_id( session[:user_id] )
      session[:select_type] = params[:select_type].to_i if params[:select_type]
      if session[:select_type] and session[:select_type] != 0
        @stocks.delete_if{|s| s.item.item_type.id != session[:select_type]}
      end
      @linktext = ''
      @linkaction = :make_order
      render 'guild/make_item_list'
    end
  end

  def cancel_order
    init
    @title = "μߤ"
    if params[:order_id] && (@order = GuildOrder.find( params[:order_id].to_i ))
      if params[:confirm]
        GuildOrder.cancel_order( @user, @order )
      else
        render 'guild/cancel_confirm'
      end
    else
      flash.now[:error] = "Ǥޤ" if params[:order_id]
      @orders = GuildOrder.find(:all, :conditions => ['owner_id = ? AND done != TRUE', @user.id ], :order => 'location_id ASC, id ASC' )
      render 'guild/ordered_list'
    end
  end

  def my_consignment_list
    init
    @title = "楢ƥꥹ"
    @consignments = GuildConsignment.find(:all, :conditions => ['user_id = ?', @user.id ], :order => 'id DESC' )
  end

  def all_consignment_list
    init
    @title = "ʰ"
    @consignments = GuildConsignment.find(:all)
    @consignments.sort do |l,r|
      if l.item.item_name == r.item.item_name
        if l.price == r.price
          r.stock <=> l.stock
        else
          l.price <=> r.price
        end
      else
        l.item.item_name <=> r.item.item_name
      end
    end
  end

  def buy_consignment
    init
    @title = "㤤"
    if params[:consignment_id]
      @consignment = GuildConsignment.find( params[:consignment_id].to_i )
      @have = Stock.find_or_create_by_user_id_and_item_id( @user.id, @consignment.item_id )
      if @consignment
        if request.post?
          begin
            flash.now[:info] = @user.buyFromShop( @consignment, @have, params[:amount].to_i, @consignment.user_id )
          rescue => e
            flash.now[:error] = e.message
          end
        end
      else
        flash.now[:error] = "ֹ椬Ǥ"
        all_consignment_list
        render 'guild/all_consignment_list'
      end
    else
      flash.now[:error] = "ֹ椬ޤ"
      all_consignment_list
      render 'guild/all_consignment_list'
    end
  end

  def make_consignment_confirm
    init
    if params[:item_id] and params[:amount] and params[:price]
      @title = ""
      @item_id = params[:item_id].to_i
      @amount = params[:amount].to_i
      @price = params[:price].to_i
      if @amount <= 0 or @price <= 0
        flash.now[:error] = "̤Ȳʤ 0 礭Ƥ"
        render 'guild/make_consignment'
      else
        @item = Item.find( @item_id )
        begin
          @result = GuildConsignment.make_consignment( @user, @item, @amount, @price )
        rescue => e
          @result = nil
          flash.now[:error] = e.message
          params[:item_id] = nil
          make_consignment
        end
      end
    else
      params[:item_id] = nil
      flash.now[:error] = "ɬפʾ­ޤ"
      make_consignment
    end
  end

  def make_consignment
    init
    if params[:item_id]
      @title = 'ʸ'
      @item = Item.find( params[:item_id].to_i )
    else
      @title = ''
      @stocks = Stock.find( :all, :conditions => [ 'user_id = ? AND stock > 0',session[:user_id]] )
      session[:select_type] = params[:select_type].to_i if params[:select_type]
      if session[:select_type] and session[:select_type] != 0
        @stocks.delete_if{|s| s.item.item_type.id != session[:select_type]}
      end
      @linktext = ''
      @linkaction = :make_consignment
      render 'guild/make_item_list'
    end
  end

  def cancel_consignment
    init
    @title = "μߤ"
    if params[:consignment_id]
      @consignment = GuildConsignment.find( params[:consignment_id].to_i )
      if params[:confirm]
        @item = @consignment.item
        @consignment.cancel_consignment( @user )
      else
        render 'guild/cancel_consignment_confirm'
      end
    else
      my_consignment_list
      render 'guild/my_consignment_list'
    end
  end

  private

  def init
    @title = ''
    @user = User.find( session[:user_id] )
    @sibu = ( @user.location.has_guild? ? @user.location.location_name + '' : '' )
  end

  def render_my_order_list( act, text, &fun )
    @orders = GuildOrder.find(:all, :conditions => ['worker_id = ? AND done != TRUE', @user.id ], :order => 'location_id ASC, id ASC' )
    @act = act
    @text = text
    @func = fun
    @func ||= lambda{|o| true }
    render 'guild/my_order_list'
  end
end
