class Admin::StockController < ApplicationController
  layout 'admin'

  def index
    list
    render :action => 'list'
  end

  # GETs should be safe (see http://www.w3.org/2001/tag/doc/whenToUseGet.html)
  verify :method => :post, :only => [ :destroy, :create, :update ],
         :redirect_to => { :action => :list }

  def list
    @stock_pages, @stocks = paginate :stocks, :per_page => 10
  end

  def show
    @stock = Stock.find(params[:id])
  end

  def new
    @stock = Stock.new
  end

  def create
    params[:stock][:item_id] = Stock.item_from_name( params[:item_str] )
    params[:stock][:user_id] = Stock.user_from_name( params[:user_str] )
    @stock = Stock.new(params[:stock])
    if @stock.save
      flash[:notice] = 'Stock was successfully created.'
      redirect_to :action => 'list'
    else
      render :action => 'new'
    end
  end

  def edit
    @stock = Stock.find(params[:id])
  end

  def update
    params[:stock][:item_id] = Stock.item_from_name( params[:item_str] )
    params[:stock][:user_id] = Stock.user_from_name( params[:user_str] )
    @stock = Stock.find(params[:id])
    if @stock.update_attributes(params[:stock])
      flash[:notice] = 'Stock was successfully updated.'
      redirect_to :action => 'show', :id => @stock
    else
      render :action => 'edit'
    end
  end

  def destroy
    Stock.find(params[:id]).destroy
    redirect_to :action => 'list'
  end
end
