class Admin::LocationController < ApplicationController
  layout 'admin'

  def index
    list
    render :action => 'list'
  end

  # GETs should be safe (see http://www.w3.org/2001/tag/doc/whenToUseGet.html)
  verify :method => :post, :only => [ :destroy, :create, :update ],
         :redirect_to => { :action => :list }

  def list
    @location_pages, @locations = paginate :locations, :per_page => 10
  end

  def show
    @location = Location.find(params[:id])
    @children = Location.find( :all, :conditions => ['parent_id = ?', @location.id] )
  end

  def new
    @location = Location.new
  end

  def create
    params[:location][:parent_id] = Location.parent_id_from_name( params[:parent_id_str] )
    @location = Location.new(params[:location])
    if @location.save
      flash[:notice] = 'Location was successfully created.'
      redirect_to :action => 'list'
    else
      render :action => 'new'
    end
  end

  def edit
    @location = Location.find(params[:id])
  end

  def update
    params[:location][:parent_id] = Location.parent_id_from_name( params[:parent_id_str] )
    @location = Location.find(params[:id])
    if @location.update_attributes(params[:location])
      flash[:notice] = 'Location was successfully updated.'
      redirect_to :action => 'show', :id => @location
    else
      render :action => 'edit'
    end
  end

  def destroy
    Location.find(params[:id]).destroy
    redirect_to :action => 'list'
  end
end
