/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.sh;

import java.util.List;

/**
 *
 *
 * @author MORIGUCHI, Yuichiro 2013/10/25
 */
public abstract class AbstractShFileSystem implements ShFileSystem {

	/**
	 * 
	 */
	protected ShFile realcur;

	/**
	 * 
	 * @param s
	 * @return
	 */
	public static String normalizePath(String s) {
		String t, v;

		t = s.replaceFirst("^/+", "/");
		t = t.replaceFirst("/+$", "");
		t = t.replaceAll("^(/\\.\\.)+", "/");
		do {
			v = t;
			t = t.replaceAll("/[^/]+/\\.\\.", "");
		} while(!t.equals(v));
		t = t.replaceAll("(/\\.)+/", "/");
		t = t.replaceAll("(/\\.)+$", "");
		t = t.equals("") ? "/" : t;
		return t;
	}

	/* (non-Javadoc)
	 * @see net.morilib.sh.ShFileSystem#getCurrentDirectory()
	 */
	public ShFile getCurrentDirectory() {
		return realcur;
	}

	/* (non-Javadoc)
	 * @see net.morilib.sh.ShFileSystem#setCurrentDirectory(net.morilib.sh.ShFile)
	 */
	public void setCurrentDirectory(ShFile s) {
		realcur = s.toCanonical();
	}

	/* (non-Javadoc)
	 * @see net.morilib.sh.ShFileSystem#searchPath(net.morilib.sh.ShEnvironment, java.lang.String)
	 */
	public ShFile searchPath(ShEnvironment env, String name) {
		List<String> p = env.getPath();
		ShFile f;

		if(name.length() == 0 || name.charAt(0) == '/') {
			return getFile(name);
		} else {
			for(String t : p) {
				if((f = getFile(t)) == null || !f.isDirectory()) {
					// do nothing
				} else if((f = getFile(t, name)) == null) {
					// do nothing
				} else if(f.isExecutable()) {
					return f;
				}
			}
			return null;
		}
	}

}
