/*
 * Copyright 2009 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.deculture.translate;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.StringWriter;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

import net.morilib.automata.lr.ContextFreeGrammar;
import net.morilib.automata.lr.ContextFreeRule;
import net.morilib.automata.lr.LALR1Table;
import net.morilib.automata.lr.LR1Table;
import net.morilib.automata.lr.LRConflict;
import net.morilib.deculture.misc.ConstantNonterminal;
import net.morilib.deculture.parser.DecultureAction;
import net.morilib.deculture.parser.DecultureDefinition;
import net.morilib.deculture.parser.DecultureReader;

/**
 * 
 * 
 * @author MORIGUCHI, Yuichiro 2006/07/09
 */
public class LRObject {

	//
	private DecultureDefinition def;
	private DecultureAction act;
	private ContextFreeGrammar grammar;
	private LR1Table table;
	private Map<ContextFreeRule, Object> actionMap =
			new HashMap<ContextFreeRule, Object>();
	private String input;

	/**
	 * 
	 * @return
	 */
	public DecultureDefinition getDefinition() {
		return def;
	}

	/**
	 * 
	 * @return
	 */
	public ContextFreeGrammar getGrammar() {
		return grammar;
	}

	/**
	 * 
	 * @return
	 */
	public LR1Table getTable() {
		return table;
	}

	/**
	 * 
	 * @return
	 */
	public Collection<LRConflict> getConflicts() {
		return table.getConflicts();
	}

	/**
	 * 
	 * @param rule
	 * @return
	 */
	public Object getAction(ContextFreeRule rule) {
		return actionMap.get(rule);
	}

	/**
	 * 
	 * @param rule
	 * @param action
	 */
	public void setAction(ContextFreeRule rule, Object action) {
		actionMap.put(rule, action);
	}

	/**
	 * 
	 * @param rule
	 */
	public void removeAction(ContextFreeRule rule) {
		actionMap.remove(rule);
	}

	/**
	 * 
	 * @return
	 */
	public Map<ContextFreeRule, Object> getActionMap() {
		return Collections.unmodifiableMap(actionMap);
	}

	/**
	 * 
	 * @return
	 */
	public String getInput() {
		return input;
	}

	private void _put(ContextFreeGrammar g) {
//		System.out.println(act.getActions());
//		System.out.println(g.getStartSymbol());
//		for(ContextFreeRule r : g.getRules()) {
//			System.out.println(r);
//		}
	}

	/**
	 * 
	 * @param in
	 * @return
	 * @throws IOException
	 */
	public static DecultureTranslator parse(InputStream in) throws IOException {
		StringWriter w = new StringWriter();
		LRObject p = new LRObject();
		char[] a = new char[1024];
		LineNumberReader rd;
		int l;

		rd = new LineNumberReader(new InputStreamReader(in));
		try {
			p.def = new DecultureDefinition();
			p.def.parseDefinition(new DecultureReader(rd));
			p.act = new DecultureAction(p.def);
			p.act.parseAction(new DecultureReader(rd));
			p.actionMap = p.act.getActions();
	
			p.grammar = ContextFreeGrammar.newInstance(
					p.act.getActions().keySet(),
					new ConstantNonterminal(p.def.getStartSymbolName()));
			p._put(p.getGrammar());
	
			p.table = LALR1Table.create(p.grammar,
					p.def.getPriority(),
					p.def.getAssociativity(),
					p.act.getPrecedences());
			while((l = rd.read(a)) >= 0)  w.write(a, 0, l);
			p.input = w.toString();
			return DecultureTranslatorFactory.newInstance(
					p.def.getLanguage(), p);
		} catch(DecultureDefinition.TokenException e) {
			throw new DecultureSyntaxException("definitionerror",
					rd.getLineNumber() + 1);
		} catch(DecultureAction.TokenException e) {
			throw new DecultureSyntaxException("actionerror",
					rd.getLineNumber() + 1);
		}
	}

}
