/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.sh;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;

import net.morilib.sh.misc.XtraceStream;

public class ShTreeSource implements ShTree {

	private ShToken filename;

	public ShTreeSource(ShToken filename) {
		this.filename = filename;
	}

	public int eval(ShEnvironment env, ShFileSystem fs,
			ShBuiltInCommands cmds, ShRuntime run, InputStream in,
			PrintStream out, PrintStream err,
			XtraceStream pr) throws IOException, ShSyntaxException {
		String s = ShTrees.substitute(env, run, fs, err, pr, filename);
		InputStream i = null;
		ShTree p;
		String z;

		try {
			if(filename == null) {
				err.println("script not specified");
				return 72;
			} else {
				i = fs.getFile(s).getInputStream();
				p = ShTrees.compile(
						ShParser.parse(i, env.getCharset()));
				return p.eval(env, fs, cmds, run, in, out, err, pr);
			}
		} finally {
			if(i != null)  i.close();
			if((z = env.getTrap(ShSignal.RETURN)) != null) {
				run.eval(env, fs, in, out, err, pr, z);
			}
		}
	}

	public void compileInternally(ShTreeExpressionMachine.Builder b,
			Object brk, Object cnt) {
		b.add(this);
	}

}
