/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.sh;


/**
 * 
 *
 *
 * @author MORIGUCHI, Yuichiro 2013/07/21
 */
public abstract class ShFileGetter {

	/**
	 * 
	 */
	public static final ShFileGetter SH_FILE = new ShFileGetter() {

		public ShFile get(ShFileSystem f, String s) {
			return f.getFile(s);
		}

	};

	/**
	 * 
	 */
	public static final ShFileGetter SH_NATIVE = new ShFileGetter() {

		public ShFile get(ShFileSystem f,
				String s) {
			return f.getNativeFile(s);
		}

	};

	/**
	 * 
	 * @param s
	 * @return
	 */
	public abstract ShFile get(ShFileSystem f, String s);

}