require "ip_addr_class"

def hostname
  name=""
  text = IO.popen("/bin/hostname")
  text.each{|str|
    name = str.chomp
  }
  
  if name.empty?
    puts "Please run \"# hostname (your_hostname)\""
    exit
  end
  
  return name
end

def get_interfaces_info(flag, eth)
  ary = Array.new
  text = IO.popen("export LANG=C ;/sbin/ifconfig #{eth} | head -2")
  text.each{|str|
    line = str.chomp
    line.split.each{|ip_add|
      ary << ip_add
    }
  }

  case flag
  when "ip_address" then
    return ary[6].split(/:/)[1]
  when "network" then
    ip_address = get_interfaces_info("ip_address", eth)
    netmask = get_interfaces_info("netmask", eth)
    ip = IP_Addr.new(netmask, ip_address, 2)
    return ip.nwork
  when "netmask" then
    return ary[8].split(/:/)[1]
  when "broadcast" then
    return ary[7].split(/:/)[1]
  when "mac_address" then
    return ary[4]
  end
end

def print_get_master_info(name, ip, nwork, nmask, bcast, mac, eth)
  puts "Hostname = " + name
  puts "IP address = " + ip
  puts "Network = " + nwork
  puts "Netmask = " + nmask
  puts "Broadcast = " + bcast
  puts "MAC address = " + mac
  puts "ETH = "+ eth
end

def write_get_master_info(name, ip, nwork, nmask, bcast, mac, eth, file)
  io = open(file, "w")
  io.puts "NAME=" + name
  io.puts "IP=" + ip
  io.puts "NETWORK=" + nwork
  io.puts "NETMASK=" + nmask
  io.puts "BROADCAST=" + bcast
  io.puts "MAC=" + mac
  io.puts "ETH="+ eth
  io.close
end

if __FILE__ == $0
  ["mac_address", "ip_address", "netmask", "network", "broadcast"].each{|i|
    p get_interfaces_info(i, "eth1")
  }
end
