/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.views;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.core.DBConfigManager;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.core.Transaction;
import zigen.plugin.db.ui.actions.SQLSourceViewerAction;
import zigen.plugin.db.ui.views.Messages;
import zigen.plugin.db.ui.views.internal.SQLSourceViewer;

public class CommitModeAction
extends SQLSourceViewerAction
implements IMenuCreator {
    Menu fMenu;
    Action autoAction;
    Action manualAction;
    boolean isAutoCommit = false;
    IDBConfig config;

    public CommitModeAction(SQLSourceViewer viewer) {
        super(viewer, "Commit Mode", 4);
        this.setImageDescriptor(DbPlugin.getDefault().getImageDescriptor("auto_commit.gif"));
        this.setMenuCreator(this);
        if (viewer != null) {
            this.config = viewer.getDbConfig();
            this.setCommitMode(this.config == null ? false : this.config.isAutoCommit());
        }
    }

    public void setSQLSourceViewer(SQLSourceViewer viewer) {
        this.fSQLSourceViewer = viewer;
        if (viewer != null) {
            this.config = viewer.getDbConfig();
            this.setCommitMode(this.config == null ? false : this.config.isAutoCommit());
        }
    }

    public void run() {
        this.isAutoCommit = !this.isAutoCommit;
        this.setCommitMode(this.isAutoCommit);
        this.autoCommitSelectHandler();
    }

    public void dispose() {
    }

    public Menu getMenu(Control parent) {
        this.fMenu = new Menu(parent);
        this.autoAction = new Action(Messages.getString("AbstractSQLExecuteView.9"), 2){

            public void run() {
                if (!CommitModeAction.this.isAutoCommit) {
                    CommitModeAction.this.isAutoCommit = !CommitModeAction.this.isAutoCommit;
                    CommitModeAction.this.setCommitMode(CommitModeAction.this.isAutoCommit);
                    CommitModeAction.this.autoCommitSelectHandler();
                }
            }
        };
        this.autoAction.setChecked(this.isAutoCommit);
        this.autoAction.setImageDescriptor(DbPlugin.getDefault().getImageDescriptor("auto_commit.gif"));
        this.addActionToMenu(this.fMenu, (IAction)this.autoAction);
        this.manualAction = new Action(Messages.getString("AbstractSQLExecuteView.10"), 2){

            public void run() {
                if (CommitModeAction.this.isAutoCommit) {
                    CommitModeAction.this.isAutoCommit = !CommitModeAction.this.isAutoCommit;
                    CommitModeAction.this.setCommitMode(CommitModeAction.this.isAutoCommit);
                    CommitModeAction.this.autoCommitSelectHandler();
                }
            }
        };
        this.manualAction.setChecked(!this.isAutoCommit);
        this.manualAction.setImageDescriptor(DbPlugin.getDefault().getImageDescriptor("manual_commit.gif"));
        this.addActionToMenu(this.fMenu, (IAction)this.manualAction);
        return this.fMenu;
    }

    private void autoCommitSelectHandler() {
        if (this.isAutoCommit()) {
            Transaction trans = Transaction.getInstance(this.config);
            if (trans == null || trans.getTransactionCount() == 0) {
                this.setCommitMode(true);
            } else {
                DbPlugin.getDefault().showWarningMessage(Messages.getString("SQLExecuteView.7"));
                this.setCommitMode(false);
            }
        } else {
            this.setCommitMode(false);
        }
        DbPlugin.fireStatusChangeListener((Object)this, 102);
    }

    public Menu getMenu(Menu parent) {
        return null;
    }

    protected void addActionToMenu(Menu parent, IAction action) {
        ActionContributionItem item = new ActionContributionItem(action);
        item.fill(parent, -1);
    }

    public final void setCommitMode(boolean _isAutoCommit) {
        this.isAutoCommit = _isAutoCommit;
        if (_isAutoCommit) {
            this.setToolTipText(Messages.getString("AbstractSQLExecuteView.11"));
            this.setImageDescriptor(DbPlugin.getDefault().getImageDescriptor("auto_commit.gif"));
        } else {
            this.setToolTipText(Messages.getString("AbstractSQLExecuteView.12"));
            this.setImageDescriptor(DbPlugin.getDefault().getImageDescriptor("manual_commit.gif"));
        }
        if (this.config != null) {
            this.config.setAutoCommit(_isAutoCommit);
            DBConfigManager.setAutoCommit(this.config, _isAutoCommit);
        }
    }

    public boolean isAutoCommit() {
        return this.isAutoCommit;
    }

    public IDBConfig getDbConfig() {
        return this.config;
    }
}

