/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.jobs;

import java.sql.Connection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.TreeViewer;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.core.DBType;
import zigen.plugin.db.core.SchemaSearcher;
import zigen.plugin.db.core.TableInfo;
import zigen.plugin.db.core.TableSearcher;
import zigen.plugin.db.core.Transaction;
import zigen.plugin.db.ext.oracle.internal.OracleSynonymInfoSearcher;
import zigen.plugin.db.ext.oracle.internal.SynonymInfo;
import zigen.plugin.db.ui.internal.Bookmark;
import zigen.plugin.db.ui.internal.ITable;
import zigen.plugin.db.ui.internal.Synonym;
import zigen.plugin.db.ui.internal.Table;
import zigen.plugin.db.ui.internal.View;
import zigen.plugin.db.ui.jobs.AbstractJob;
import zigen.plugin.db.ui.jobs.Messages;
import zigen.plugin.db.ui.jobs.RefreshColumnJob;

public class RefreshTableJob
extends AbstractJob {
    private TreeViewer viewer;
    private ITable tableNode;

    public RefreshTableJob(TreeViewer viewer, ITable tableNode) {
        super(Messages.getString("RefreshTableJob.0"));
        this.viewer = viewer;
        this.tableNode = tableNode;
    }

    protected IStatus run(IProgressMonitor monitor) {
        TableInfo tableInfo = null;
        try {
            Table nTable;
            Connection con = Transaction.getInstance(this.tableNode.getDbConfig()).getConnection();
            tableInfo = SchemaSearcher.isSupport(con) ? TableSearcher.execute(con, this.tableNode.getSchemaName(), this.tableNode.getName(), this.tableNode.getFolderName()) : TableSearcher.execute(con, null, this.tableNode.getName(), this.tableNode.getFolderName());
            String lable = this.tableNode.getFolderName();
            if ("SYNONYM".equals(lable)) {
                switch (DBType.getType(con.getMetaData())) {
                    case 1: {
                        String owner = this.tableNode.getSchemaName();
                        String synonymName = tableInfo.getName();
                        SynonymInfo info = OracleSynonymInfoSearcher.execute(con, owner, synonymName);
                        Synonym _synonym = new Synonym(tableInfo.getName(), tableInfo.getComment());
                        _synonym.setSynonymInfo(info);
                        if (this.tableNode instanceof Bookmark) {
                            ((Bookmark)this.tableNode).update(_synonym);
                            break;
                        }
                        ((Synonym)this.tableNode).update(_synonym);
                        break;
                    }
                }
            } else if ("VIEW".equals(lable)) {
                nTable = new View(tableInfo.getName(), tableInfo.getComment());
                if (this.tableNode instanceof Bookmark) {
                    ((Bookmark)this.tableNode).update(nTable);
                } else {
                    ((View)this.tableNode).update(nTable);
                }
            } else {
                nTable = new Table(tableInfo.getName(), tableInfo.getComment());
                if (this.tableNode instanceof Bookmark) {
                    ((Bookmark)this.tableNode).update(nTable);
                } else {
                    ((Table)this.tableNode).update(nTable);
                }
            }
            RefreshColumnJob job2 = new RefreshColumnJob(this.viewer, this.tableNode);
            job2.setPriority(20);
            job2.schedule();
            try {
                job2.join();
            }
            catch (InterruptedException e) {
                DbPlugin.log(e);
            }
        }
        catch (Exception e) {
            this.showErrorMessage(Messages.getString("RefreshTableJob.3"), e);
        }
        return Status.OK_STATUS;
    }
}

