/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.editors.internal.wizard;

import org.eclipse.jface.wizard.IWizardPage;
import zigen.plugin.db.core.TableInfo;
import zigen.plugin.db.core.rule.ISQLCreatorFactory;
import zigen.plugin.db.ui.editors.internal.wizard.DefaultWizard;
import zigen.plugin.db.ui.editors.internal.wizard.FKWizardPage1;
import zigen.plugin.db.ui.editors.internal.wizard.FKWizardPage2;
import zigen.plugin.db.ui.editors.internal.wizard.IConfirmDDLWizard;
import zigen.plugin.db.ui.editors.internal.wizard.Messages;
import zigen.plugin.db.ui.internal.Column;
import zigen.plugin.db.ui.internal.DataBase;
import zigen.plugin.db.ui.internal.Folder;
import zigen.plugin.db.ui.internal.ITable;
import zigen.plugin.db.ui.internal.Schema;
import zigen.plugin.db.ui.internal.Table;

public class FKWizard
extends DefaultWizard
implements IConfirmDDLWizard {
    private FKWizardPage1 page1;
    private FKWizardPage2 page2;

    public FKWizard(ISQLCreatorFactory factory, ITable tableNode) {
        super(factory, tableNode);
        super.setWindowTitle(Messages.getString("FKWizard.0"));
        this.factory = factory;
        this.tableNode = tableNode;
        this.setNeedsProgressMonitor(true);
        this.setHelpAvailable(false);
    }

    public void addPages() {
        this.page1 = new FKWizardPage1(this.factory, this.tableNode);
        this.page2 = new FKWizardPage2(this.factory, this.tableNode);
        this.addPage((IWizardPage)this.page1);
        this.addPage((IWizardPage)this.page2);
        this.addPage((IWizardPage)this.confirmPage);
    }

    public boolean canFinish() {
        return this.page1.isPageComplete() && this.page2.isPageComplete() && this.confirmPage.isPageComplete();
    }

    public String[] createSQL() throws Exception {
        String constraintName = this.page1.txtConstraintName.getText();
        Column[] columns = this.page1.selectedList.toArray(new Column[0]);
        TableInfo tableinfo = this.page2.getRerenceTableInfo();
        DataBase database = (DataBase)this.tableNode.getDataBase().clone();
        Schema schema = this.tableNode.getSchema();
        Folder folder = this.tableNode.getFolder();
        Table refTable = new Table(tableinfo.getName(), tableinfo.getComment());
        if (this.tableNode.isSchemaSupport()) {
            database.addChild(schema);
            schema.addChild(folder);
            folder.addChild(refTable);
        } else {
            database.addChild(folder);
            folder.addChild(refTable);
        }
        Column[] refColumns = this.page2.selectedList.toArray(new Column[0]);
        boolean onCascadeDelete = this.page2.chkDeleteCascade.getSelection();
        String sql = this.factory.createCreateConstraintFKDDL(constraintName, columns, refTable, refColumns, onCascadeDelete);
        return new String[]{sql};
    }
}

