/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.editors;

import java.sql.SQLException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import kry.sql.tokenizer.SqlTokenizer;
import kry.sql.tokenizer.Token;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPainter;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.ICharacterPairMatcher;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.jface.text.source.LineNumberRulerColumn;
import org.eclipse.jface.text.source.MatchingCharacterPainter;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.CoolItem;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.MultiPageEditorPart;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.IStatusChangeListener;
import zigen.plugin.db.ImageCacher;
import zigen.plugin.db.core.Condition;
import zigen.plugin.db.core.ConditionManager;
import zigen.plugin.db.core.ConnectionManager;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.core.SQLFormatter;
import zigen.plugin.db.core.TableColumn;
import zigen.plugin.db.core.TableElement;
import zigen.plugin.db.core.TableManager;
import zigen.plugin.db.core.TimeWatcher;
import zigen.plugin.db.core.Transaction;
import zigen.plugin.db.core.rule.AbstractSQLCreatorFactory;
import zigen.plugin.db.core.rule.ISQLCreatorFactory;
import zigen.plugin.db.ui.actions.CopyRecordDataAction;
import zigen.plugin.db.ui.actions.DeleteRecordAction;
import zigen.plugin.db.ui.actions.GlobalAction;
import zigen.plugin.db.ui.actions.ITableViewEditorAction;
import zigen.plugin.db.ui.actions.InsertRecordAction;
import zigen.plugin.db.ui.actions.MaxRecordException;
import zigen.plugin.db.ui.actions.PasteRecordDataAction;
import zigen.plugin.db.ui.actions.SelectAllRecordAction;
import zigen.plugin.db.ui.editors.CellModifier;
import zigen.plugin.db.ui.editors.ColumnFilterDialog;
import zigen.plugin.db.ui.editors.IPageChangeListener;
import zigen.plugin.db.ui.editors.ITableViewEditor;
import zigen.plugin.db.ui.editors.Messages;
import zigen.plugin.db.ui.editors.TableDefineEditor;
import zigen.plugin.db.ui.editors.TableViewContentProvider;
import zigen.plugin.db.ui.editors.TableViewEditorInput;
import zigen.plugin.db.ui.editors.TableViewLabelProvider;
import zigen.plugin.db.ui.editors.TableViewerContributor;
import zigen.plugin.db.ui.editors.TableViewerPager;
import zigen.plugin.db.ui.editors.TextCellEditor;
import zigen.plugin.db.ui.editors.event.TableDefaultSortListener;
import zigen.plugin.db.ui.editors.event.TableKeyAdapter;
import zigen.plugin.db.ui.editors.event.TableKeyEventHandler;
import zigen.plugin.db.ui.editors.event.TableSortListener;
import zigen.plugin.db.ui.editors.exceptions.NotFoundColumnInfoException;
import zigen.plugin.db.ui.editors.exceptions.NotFoundSynonymInfoException;
import zigen.plugin.db.ui.editors.internal.CellEditorType;
import zigen.plugin.db.ui.editors.internal.ColumnFilterInfo;
import zigen.plugin.db.ui.editors.internal.FileCellEditor;
import zigen.plugin.db.ui.editors.internal.thread.ModifyTableThread;
import zigen.plugin.db.ui.internal.Column;
import zigen.plugin.db.ui.internal.ITable;
import zigen.plugin.db.ui.jobs.ChangeColorJob;
import zigen.plugin.db.ui.jobs.RecordCountForTableJob;
import zigen.plugin.db.ui.jobs.RecordSearchJob;
import zigen.plugin.db.ui.jobs.RefreshColumnJob;
import zigen.plugin.db.ui.jobs.RefreshTreeNodeAction;
import zigen.plugin.db.ui.jobs.TableFilterJob;
import zigen.plugin.db.ui.util.LineNumberRulerColumnUtil;
import zigen.plugin.db.ui.util.StyledTextUtil;
import zigen.plugin.db.ui.views.StatusLineContributionItem;
import zigen.plugin.db.ui.views.TreeView;
import zigen.plugin.db.ui.views.internal.ColorManager;
import zigen.plugin.db.ui.views.internal.DDLToolBar;
import zigen.plugin.db.ui.views.internal.SQLCharacterPairMatcher;
import zigen.plugin.db.ui.views.internal.SQLCodeConfiguration;
import zigen.plugin.db.ui.views.internal.SQLDocument;
import zigen.plugin.db.ui.views.internal.SQLSourceViewer;

public class TableViewEditorFor31
extends MultiPageEditorPart
implements ITableViewEditor,
IPropertyChangeListener,
ISelectionListener,
IStatusChangeListener,
IPageChangeListener {
    private boolean isEditing = false;
    private ConditionManager condiitonMgr = DbPlugin.getDefault().getConditionManager();
    private IDBConfig config;
    private SourceViewer logViewer;
    private TableViewer viewer;
    protected SQLSourceViewer ddlViewer;
    protected SQLCodeConfiguration sqlConfiguration;
    protected ColorManager colorManager = new ColorManager();
    protected ImageCacher ic = ImageCacher.getInstance();
    private Table table;
    protected ITable tableNode;
    private CellEditor[] cellEditors;
    private Label infoLabel;
    private TableElement[] elements;
    private int maxSize = 10;
    private List conditionHistory = new ArrayList();
    protected Combo conditionComb;
    private static final int CONDITION_SHOW_COLS = 20;
    private TableKeyEventHandler handler;
    protected InsertRecordAction insertRecordAction;
    protected SelectAllRecordAction selectAllRecordAction;
    protected DeleteRecordAction deleteAction;
    protected CopyRecordDataAction copyAction;
    protected PasteRecordDataAction pasteAction;
    protected ChangeColorJob changeColorJob;
    private TableSortListener sortListener;
    protected ColumnFilterInfo[] filterInfos;
    protected StatusLineContributionItem responseTimeItem;
    protected String responseTime;
    protected ISelection selection;
    protected MatchingCharacterPainter painter;
    protected LineNumberRulerColumn rulerCol;
    protected ToolItem searchItem;
    protected ToolItem filterItem;
    protected ToolItem pingColumnItem;
    private boolean isLockedColumnWidth;
    protected IPreferenceStore ps;
    protected Condition fCondition;
    protected int offset = 1;
    protected int limit = 0;
    protected long totalCount;
    protected Label totalPage;
    protected DDLToolBar toolBar;
    protected TableViewerPager pager;
    protected ToolItem addToolItem;
    protected ToolItem deleteToolItem;
    protected CoolItem pagerItem;
    protected CoolItem infoLabelItem;
    protected String whereString;
    boolean checkFilterPattern = false;
    String filterPattern = null;
    private int max_column_size = 600;
    private Object lock = new Object();
    private TableDefineEditor tableDefineEditor;
    boolean dirty;
    static Object loadingColumnInfolock = new Object();
    boolean isLodingColumnInfo = false;
    boolean isExistDDLPage = false;
    boolean isExistDefinePage = false;
    private List extensionList = new ArrayList();

    public TableViewEditorFor31() {
        this.ps = DbPlugin.getDefault().getPreferenceStore();
        this.isLockedColumnWidth = this.ps.getBoolean("PreferencePage.LogColumnWidth");
    }

    private void makeActions() {
        this.insertRecordAction = new InsertRecordAction();
        this.selectAllRecordAction = new SelectAllRecordAction();
        this.deleteAction = new DeleteRecordAction();
        this.copyAction = new CopyRecordDataAction();
        this.pasteAction = new PasteRecordDataAction();
        this.insertRecordAction.setActiveEditor(this);
        this.selectAllRecordAction.setActiveEditor(this);
        this.deleteAction.setActiveEditor(this);
        this.copyAction.setActiveEditor(this);
        this.pasteAction.setActiveEditor(this);
    }

    private void saveConditionHistory() {
        String schemaName = this.tableNode.getSchemaName();
        String tableName = this.tableNode.getName();
        Condition condition = new Condition();
        String url = this.config.getUrl();
        condition.setConnectionUrl(url);
        condition.setSchema(schemaName);
        condition.setTable(tableName);
        condition.setConditions(this.conditionHistory);
        condition.setFilterPattern(this.filterPattern);
        condition.setCheckFilterPattern(false);
        this.condiitonMgr.setCondition(condition);
    }

    private void loadConditionHistory() {
        String url = this.config.getUrl();
        String schemaName = this.tableNode.getSchemaName();
        String tableName = this.tableNode.getName();
        this.fCondition = this.condiitonMgr.getCondition(url, schemaName, tableName);
        if (this.fCondition != null) {
            this.conditionHistory = this.fCondition.getConditions();
            this.checkFilterPattern = this.fCondition.isCheckFilterPattern();
            this.filterPattern = this.fCondition.getFilterPattern();
        }
    }

    protected void createPages() {
        this.makeActions();
        Composite composite = new Composite(this.getContainer(), 0);
        composite.setLayout((Layout)new FillLayout());
        int index = this.addPage((Control)composite);
        this.setPageText(index, "Dummy");
        this.loadConditionHistory();
        DbPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        DbPlugin.addStatusChangeListener(this);
    }

    private void createDDLPage() {
        Composite composite = new Composite(this.getContainer(), 0);
        FormLayout layout = new FormLayout();
        composite.setLayout((Layout)layout);
        this.toolBar = new DDLToolBar(composite, (IEditorPart)this);
        Composite sqlComposite = new Composite(composite, 0);
        sqlComposite.setLayout((Layout)new FillLayout());
        FormData data = new FormData();
        data.top = new FormAttachment((Control)this.toolBar.getCoolBar(), 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.bottom = new FormAttachment(100, 0);
        sqlComposite.setLayoutData((Object)data);
        CompositeRuler ruler = new CompositeRuler();
        this.rulerCol = new LineNumberRulerColumn();
        ruler.addDecorator(0, (IVerticalRulerColumn)this.rulerCol);
        LineNumberRulerColumnUtil.changeColor(this.colorManager, this.rulerCol);
        this.ddlViewer = new SQLSourceViewer(sqlComposite, (IVerticalRuler)ruler, null, false, 2818);
        this.ddlViewer.setSqlFileName(this.tableNode.getName());
        this.toolBar.setSQLSourceViewer(this.ddlViewer);
        this.initializeViewerFont((ISourceViewer)this.ddlViewer);
        this.sqlConfiguration = new SQLCodeConfiguration(this.colorManager);
        this.ddlViewer.configure(this.sqlConfiguration);
        this.ddlViewer.setDocument((IDocument)new SQLDocument());
        SQLSourceViewer extension = this.ddlViewer;
        this.painter = new MatchingCharacterPainter((ISourceViewer)this.ddlViewer, (ICharacterPairMatcher)new SQLCharacterPairMatcher());
        this.painter.setColor(this.colorManager.getColor("SQLEditorPreferencePage.ColorMatching"));
        extension.addPainter((IPainter)this.painter);
        StyledTextUtil.changeColor(this.colorManager, this.ddlViewer.getTextWidget());
        this.ddlViewer.setEditable(false);
        int index = this.addPage((Control)composite);
        this.setPageText(index, "DDL");
    }

    private void createMessageArea(Composite parent) {
        CoolBar coolBar1 = new CoolBar(parent, 0);
        GridData gridData = new GridData(768);
        coolBar1.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        coolBar1.setLayout((Layout)gridLayout);
        this.pagerItem = new CoolItem(coolBar1, 0x800000);
        this.pager = new TableViewerPager(this.tableNode, this.limit);
        this.pagerItem.setControl(this.pager.createStackedButtons((Composite)coolBar1));
        this.computeSize(this.pagerItem);
        this.pager.setPageNo(1);
        this.pager.addPageChangeListener(this);
        this.infoLabelItem = new CoolItem(coolBar1, 0);
        this.infoLabel = new Label((Composite)coolBar1, 0);
        this.infoLabel.setText("");
        this.infoLabel.setForeground(new Color(null, 255, 0, 0));
        this.infoLabelItem.setControl((Control)this.infoLabel);
        this.computeSize(this.infoLabelItem);
    }

    private void createMainPage() {
        Composite main = new Composite(this.getContainer(), 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.makeColumnsEqualWidth = false;
        gridLayout.marginHeight = 2;
        gridLayout.marginWidth = 2;
        gridLayout.horizontalSpacing = 2;
        gridLayout.verticalSpacing = 2;
        main.setLayout((Layout)gridLayout);
        this.createToolBar(main);
        this.table = new Table(main, 68354);
        this.createMessageArea(main);
        GridData gridData2 = new GridData(1808);
        this.table.setLayoutData((Object)gridData2);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        this.table.setFont(DbPlugin.getDefaultFont());
        this.viewer = new TableViewer(this.table);
        this.handler = new TableKeyEventHandler(this);
        this.setHeaderColumn(this.table);
        this.viewer.setContentProvider((IContentProvider)new TableViewContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new TableViewLabelProvider());
        this.table.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x100000B) {
                    int row = TableViewEditorFor31.this.handler.getSelectedRow();
                    TableViewEditorFor31.this.handler.editTableElement(row, 1);
                }
            }
        });
        this.table.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                if (TableViewEditorFor31.this.table.getSelectionIndex() == -1) {
                    TableViewEditorFor31.this.table.select(0);
                    TableViewEditorFor31.this.table.notifyListeners(13, null);
                }
                IActionBars bars = TableViewEditorFor31.this.getEditorSite().getActionBars();
                TableViewEditorFor31.this.setGlobalActionForEditor(bars);
                bars.updateActionBars();
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                TableViewEditorFor31.this.selectionChangeHandler(e);
            }
        });
        this.viewer.setInput((Object)this.elements);
        this.columnsPack(this.table);
        this.contributeToStatusLine();
        this.addPage(0, (Control)main);
        this.removePage(1);
        this.setActivePage(0);
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.getEditorSite().getPage().addSelectionListener((ISelectionListener)this);
        this.setKeyBinding();
        this.changeColorJob = new ChangeColorJob(this.table, this.tableNode);
        this.changeColorJob.setPriority(30);
        this.changeColorJob.setUser(false);
        this.changeColorJob.schedule();
    }

    protected void setKeyBinding() {
    }

    private boolean hasContributionItem(IStatusLineManager manager, String id) {
        IContributionItem[] items = manager.getItems();
        int i = 0;
        while (i < items.length) {
            IContributionItem item = items[i];
            if (item.getId().equals(id)) {
                this.responseTimeItem = (StatusLineContributionItem)item;
                return true;
            }
            ++i;
        }
        return false;
    }

    public void contributeToStatusLine() {
        IStatusLineManager manager = this.getIStatusLineManager();
        if (!this.hasContributionItem(manager, "RecordCount")) {
            this.responseTimeItem = new StatusLineContributionItem("RecordCount");
            manager.add((IContributionItem)this.responseTimeItem);
        }
    }

    protected void conditionEventHandler(KeyEvent e) {
        if (e.character == '\r') {
            e.doit = true;
            this.whereString = this.conditionComb.getText();
            this.pager.setPageNo(1);
            this.offset = 1;
            this.limit = DbPlugin.getDefault().getPreferenceStore().getInt("PreferencePage.MaxViewRecord");
            this.updateTableViewer(this.whereString, this.offset, this.limit);
        }
    }

    public void pageChanged(int status, int offset, int limit) {
        this.offset = offset;
        this.limit = limit;
        this.whereString = this.conditionComb.getText();
        this.updateTableViewer(this.whereString, offset, limit);
    }

    public void setTotalCount(int dispCount, long totalCount) {
        this.totalCount = totalCount;
        NumberFormat format = NumberFormat.getInstance();
        String displayCount = format.format(dispCount);
        String displayTotalCount = format.format(totalCount);
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        sb.append(this.config.getDbName());
        sb.append("] ");
        sb.append(displayCount);
        sb.append("");
        if (!"".equals(displayTotalCount)) {
            if (!"-1".equals(displayTotalCount)) {
                sb.append(" / ");
                sb.append("");
                sb.append(displayTotalCount);
                sb.append(Messages.getString("TableViewEditorFor31.12"));
            }
        } else {
            sb.append(Messages.getString("TableViewEditorFor31.13"));
        }
        sb.append(Messages.getString("TableViewEditorFor31.14"));
        sb.append(this.responseTime);
        sb.append("]");
        this.setPageText(0, sb.toString());
        this.pager.setLimit(this.limit);
        this.pager.setRecordCount((int)totalCount);
        this.computeSize(this.pagerItem);
    }

    public void setResponseTime(String responseTime) {
        this.responseTime = responseTime;
        if (this.responseTimeItem != null && responseTime != null && !"".equals(responseTime)) {
            StringBuffer sb = new StringBuffer();
            sb.append(Messages.getString("TableViewEditorFor31.17"));
            sb.append(responseTime);
            this.responseTimeItem.setText(sb.toString());
        }
    }

    public void refleshAction() {
        this.deleteAction.refresh();
        this.copyAction.refresh();
        this.pasteAction.refresh();
        if (this.table.getSelectionCount() > 0) {
            this.deleteToolItem.setEnabled(true);
        } else {
            this.deleteToolItem.setEnabled(false);
        }
    }

    void selectionChangeHandler(SelectionChangedEvent event) {
        this.refleshAction();
    }

    private void createToolBar(Composite parent) {
        CoolBar coolBar = new CoolBar(parent, 0x800000);
        GridData gridData = new GridData(768);
        coolBar.setLayoutData((Object)gridData);
        ToolBar toolBar1 = new ToolBar((Composite)coolBar, 256);
        this.addToolItem = new ToolItem(toolBar1, 8);
        this.addToolItem.setImage(this.ic.getImage("add.gif"));
        this.addToolItem.setToolTipText(Messages.getString("TableViewEditorFor31.9"));
        this.addToolItem.setEnabled(false);
        this.addToolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InsertRecordAction action = TableViewEditorFor31.this.getContributor().getInsertRecordAction();
                action.run();
            }
        });
        this.deleteToolItem = new ToolItem(toolBar1, 8);
        this.deleteToolItem.setImage(this.getImage("IMG_TOOL_DELETE"));
        this.deleteToolItem.setToolTipText(Messages.getString("TableViewEditorFor31.8"));
        this.deleteToolItem.setEnabled(false);
        this.computeSize(coolBar, toolBar1);
        this.deleteToolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DeleteRecordAction action = TableViewEditorFor31.this.getContributor().getDeleteRecordAction();
                action.run();
            }
        });
        ToolBar toolBar3 = new ToolBar((Composite)coolBar, 256);
        this.searchItem = new ToolItem(toolBar3, 0);
        this.searchItem.setImage(this.ic.getImage("execute.gif"));
        this.searchItem.setEnabled(false);
        this.searchItem.setToolTipText(Messages.getString("TableViewEditorFor31.19"));
        this.searchItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableViewEditorFor31.this.whereString = TableViewEditorFor31.this.conditionComb.getText();
                TableViewEditorFor31.this.pager.setPageNo(1);
                TableViewEditorFor31.this.offset = 1;
                TableViewEditorFor31.this.limit = DbPlugin.getDefault().getPreferenceStore().getInt("PreferencePage.MaxViewRecord");
                TableViewEditorFor31.this.updateTableViewer(TableViewEditorFor31.this.whereString, TableViewEditorFor31.this.offset, TableViewEditorFor31.this.limit);
            }
        });
        this.computeSize(coolBar, toolBar3);
        ToolBar toolBar2 = new ToolBar((Composite)coolBar, 256);
        this.filterItem = new ToolItem(toolBar2, 0);
        this.filterItem.setImage(this.ic.getImage("filter.gif"));
        this.filterItem.setEnabled(false);
        this.filterItem.setToolTipText(Messages.getString("TableViewEditorFor31.20"));
        this.filterItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableViewEditorFor31.this.filterBtnSelectHandler(e);
            }
        });
        this.pingColumnItem = new ToolItem(toolBar2, 32);
        this.pingColumnItem.setImage(this.ic.getImage("pin_column.gif"));
        this.pingColumnItem.setSelection(this.isLockedColumnWidth);
        this.pingColumnItem.setEnabled(false);
        this.pingColumnItem.setToolTipText(Messages.getString("TableViewEditorFor31.29"));
        this.pingColumnItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableViewEditorFor31.this.isLockedColumnWidth = !TableViewEditorFor31.this.isLockedColumnWidth;
            }
        });
        this.computeSize(coolBar, toolBar2);
        Composite tool = new Composite(parent, 0);
        gridData = new GridData(768);
        tool.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        gridLayout.makeColumnsEqualWidth = false;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        tool.setLayout((Layout)gridLayout);
        Label label1 = new Label(tool, 0);
        gridData = new GridData(4);
        gridData.verticalIndent = 2;
        label1.setLayoutData((Object)gridData);
        label1.setText(Messages.getString("TableViewEditorFor31.18"));
        this.conditionComb = new Combo(tool, 0);
        this.conditionComb.setEnabled(false);
        if (this.whereString != null && !"".equals(this.whereString)) {
            this.conditionComb.setText(this.whereString);
        }
        this.conditionComb.setVisibleItemCount(20);
        this.conditionComb.setLayoutData((Object)new GridData(768));
        this.conditionComb.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                TableViewEditorFor31.this.conditionEventHandler(e);
            }
        });
        this.conditionComb.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.character == '\t' && TableViewEditorFor31.this.table.getItemCount() == 0) {
                    TableViewEditorFor31.this.handler.createNewRecord();
                }
            }
        });
        this.conditionComb.setFont(DbPlugin.getDefaultFont());
        this.conditionComb.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                IActionBars bars = TableViewEditorFor31.this.getEditorSite().getActionBars();
                bars.clearGlobalActionHandlers();
                bars.updateActionBars();
            }
        });
        this.conditionComb.setFocus();
        if (this.conditionHistory != null) {
            if (this.conditionHistory.size() == 0) {
                this.conditionComb.add("");
            } else {
                int i = 0;
                while (i < this.conditionHistory.size()) {
                    this.conditionComb.add((String)this.conditionHistory.get(i));
                    ++i;
                }
            }
        }
    }

    protected Image getImage(String key) {
        return PlatformUI.getWorkbench().getSharedImages().getImage(key);
    }

    private void computeSize(CoolBar coolBar, ToolBar cToolBar) {
        CoolItem item = new CoolItem(coolBar, 8);
        cToolBar.pack();
        Point size = cToolBar.getSize();
        item.setControl((Control)cToolBar);
        item.setSize(item.computeSize(size.x + 5, size.y));
    }

    private void computeSize(CoolItem item) {
        Control control = item.getControl();
        Point pt = control.computeSize(-1, -1);
        pt = item.computeSize(pt.x + 5, pt.y);
        item.setSize(pt);
    }

    private void filterBtnSelectHandler(SelectionEvent event) {
        Shell shell = this.getSite().getShell();
        ColumnFilterDialog dialog = new ColumnFilterDialog(shell, this);
        int ret = dialog.open();
        if (ret == 0) {
            this.checkFilterPattern = dialog.isFilterPattern;
            this.filterPattern = dialog.filterPattern;
        }
    }

    public void removeOverHistory() {
        while (this.conditionHistory.size() > this.maxSize) {
            int i = this.conditionHistory.size() - 1;
            this.conditionHistory.remove(i);
            this.conditionComb.remove(i);
        }
    }

    void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                switch (TableViewEditorFor31.this.getActivePage()) {
                    case 2: {
                        if (TableViewEditorFor31.this.tableDefineEditor.focusDefine()) {
                            ISelection selection = TableViewEditorFor31.this.tableDefineEditor.getDefineViewer().getSelection();
                            TableViewEditorFor31.this.getContributor().fillContextMenuForDefine(manager, selection);
                            break;
                        }
                        ISelection selection = TableViewEditorFor31.this.tableDefineEditor.getConstraintViewer().getSelection();
                        TableViewEditorFor31.this.getContributor().fillContextMenuForConstraints(manager, selection);
                        break;
                    }
                    case 1: {
                        TableViewEditorFor31.this.getContributor().fillContextMenuForDDL(manager);
                        break;
                    }
                    case 0: {
                        TableViewEditorFor31.this.getContributor().fillContextMenu(manager);
                        TableViewEditorFor31.this.setExtensionPoint(manager);
                        break;
                    }
                }
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
        if (this.tableDefineEditor != null) {
            Menu menu2 = menuMgr.createContextMenu(this.tableDefineEditor.getDefineViewer().getControl());
            this.tableDefineEditor.getDefineViewer().getControl().setMenu(menu2);
            this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.tableDefineEditor.getDefineViewer());
            Menu menu3 = menuMgr.createContextMenu(this.tableDefineEditor.getConstraintViewer().getControl());
            this.tableDefineEditor.getConstraintViewer().getControl().setMenu(menu3);
            this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.tableDefineEditor.getConstraintViewer());
        }
        if (this.ddlViewer != null) {
            Menu menu4 = menuMgr.createContextMenu((Control)this.ddlViewer.getTextWidget());
            this.ddlViewer.getTextWidget().setMenu(menu4);
            this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.ddlViewer);
        }
    }

    private TableViewerContributor getContributor() {
        IEditorActionBarContributor contributor = this.getEditorSite().getActionBarContributor();
        if (contributor instanceof TableViewerContributor) {
            return (TableViewerContributor)contributor;
        }
        return null;
    }

    private void setHeaderColumn(Table table) {
        if (this.elements != null) {
            org.eclipse.swt.widgets.TableColumn row = new org.eclipse.swt.widgets.TableColumn(table, 131072);
            this.sortListener = new TableSortListener(this, 0);
            row.addSelectionListener((SelectionListener)this.sortListener);
            row.pack();
            TableElement element = this.elements[0];
            TableColumn[] columns = element.getColumns();
            int i = 0;
            while (i < columns.length) {
                TableColumn tColumn = columns[i];
                org.eclipse.swt.widgets.TableColumn col = new org.eclipse.swt.widgets.TableColumn(table, 16384);
                col.setText(tColumn.getColumnName());
                col.addSelectionListener((SelectionListener)new TableSortListener(this, i + 1));
                col.pack();
                ++i;
            }
        }
    }

    private void setCellModify(TableViewer viewer, ColumnFilterInfo[] filterInfo, TableKeyEventHandler handler) {
        if (this.elements == null) {
            return;
        }
        final IActionBars bars = this.getEditorSite().getActionBars();
        TableElement element = this.elements[0];
        int size = element.getColumns().length + 1;
        String[] properties = new String[size];
        TableColumn[] cols = element.getColumns();
        this.cellEditors = new CellEditor[size];
        TableKeyAdapter keyAdapter = new TableKeyAdapter(handler);
        int i = 0;
        while (i < this.cellEditors.length) {
            properties[i] = String.valueOf(i);
            if (i > 0) {
                Object cellEditor = null;
                if (CellEditorType.isFileSaveType(cols[i - 1])) {
                    cellEditor = new FileCellEditor((Composite)this.table);
                    ((FileCellEditor)((Object)cellEditor)).addKeyListener(keyAdapter);
                    ((FileCellEditor)((Object)cellEditor)).addTraverseListener(keyAdapter);
                } else {
                    cellEditor = new TextCellEditor(this.table, i);
                    cellEditor.getControl().addKeyListener((KeyListener)keyAdapter);
                    cellEditor.getControl().addTraverseListener((TraverseListener)keyAdapter);
                }
                cellEditor.getControl().addFocusListener((FocusListener)new FocusAdapter(){

                    public void focusGained(FocusEvent e) {
                        TableViewEditorFor31.this.setInfomationText(EDIT_MODE_ON);
                        TableViewEditorFor31.this.isEditing = true;
                        bars.clearGlobalActionHandlers();
                        bars.updateActionBars();
                    }

                    public void focusLost(FocusEvent e) {
                        TableViewEditorFor31.this.setInfomationText(EDIT_MODE_OFF);
                        TableViewEditorFor31.this.isEditing = false;
                    }
                });
                this.cellEditors[i] = cellEditor;
            }
            ++i;
        }
        viewer.setColumnProperties(properties);
        viewer.setCellModifier((ICellModifier)new CellModifier(this, filterInfo, handler));
        viewer.setCellEditors(this.cellEditors);
    }

    private void columnsPack(Table table) {
        table.setVisible(false);
        org.eclipse.swt.widgets.TableColumn[] cols = table.getColumns();
        int i = 0;
        while (i < cols.length) {
            org.eclipse.swt.widgets.TableColumn c = cols[i];
            c.pack();
            if (c.getWidth() > this.max_column_size) {
                c.setWidth(this.max_column_size);
            }
            ++i;
        }
        table.setVisible(true);
    }

    public void dispose() {
        DbPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        this.getEditorSite().getPage().removeSelectionListener((ISelectionListener)this);
        DbPlugin.removeStatusChangeListener(this);
        this.insertRecordAction.setActiveEditor(null);
        this.selectAllRecordAction.setActiveEditor(null);
        this.deleteAction.setActiveEditor(null);
        this.copyAction.setActiveEditor(null);
        this.pasteAction.setActiveEditor(null);
        if (this.handler != null) {
            this.handler.dispose();
            this.handler = null;
        }
        this.saveConditionHistory();
        super.dispose();
    }

    public void init(IEditorSite site, IEditorInput editorInput) throws PartInitException {
        super.init(site, editorInput);
        try {
            if (editorInput instanceof TableViewEditorInput) {
                TableViewEditorInput input = (TableViewEditorInput)editorInput;
                this.config = input.getConfig();
                this.tableNode = input.getTable();
                String partName = this.tableNode.getSqlTableName();
                this.setPartName(partName);
                StringBuffer sb = new StringBuffer();
                sb.append("[");
                sb.append(input.getConfig().getDbName());
                sb.append("] ");
                sb.append(partName);
                if (this.tableNode.getRemarks() != null && !"".equals(this.tableNode.getRemarks().trim())) {
                    sb.append(" [");
                    sb.append(this.tableNode.getRemarks());
                    sb.append("]");
                }
                input.setToolTipText(sb.toString());
                this.setStatusMessage(input.getToolTipText());
            }
        }
        catch (Exception e) {
            DbPlugin.getDefault().showErrorDialog(e);
        }
    }

    protected void updateTableViewer(String condition, int offset, int limit) {
        if (limit == 0) {
            offset = 0;
        }
        RecordSearchJob job = new RecordSearchJob(this, condition, this.getOrderByString(), offset, limit);
        job.setPriority(20);
        job.setUser(true);
        job.schedule();
    }

    public void updateTableViewer(String condition, TableElement[] elements, String responseTime, boolean doCalculate) {
        try {
            String unformated;
            this.viewer.setInput((Object)elements);
            org.eclipse.swt.widgets.TableColumn col = this.viewer.getTable().getColumn(0);
            col.pack();
            TableDefaultSortListener defaultSortListener = new TableDefaultSortListener(this, 0);
            col.removeSelectionListener((SelectionListener)this.sortListener);
            col.addSelectionListener((SelectionListener)defaultSortListener);
            this.viewer.getTable().getColumn(0).notifyListeners(13, null);
            col.removeSelectionListener((SelectionListener)defaultSortListener);
            this.sortListener = new TableSortListener(this, 0);
            col.addSelectionListener((SelectionListener)this.sortListener);
            if (!this.isLockedColumnWidth) {
                this.columnsPack(this.table);
                TableFilterJob job = new TableFilterJob(this.viewer, this.filterInfos);
                job.setPriority(20);
                job.setUser(false);
                job.schedule();
            }
            if (this.conditionHistory.contains(unformated = SQLFormatter.unformat(condition))) {
                this.conditionHistory.remove(unformated);
                this.conditionComb.remove(unformated);
            }
            this.conditionHistory.add(0, unformated);
            this.conditionComb.add(unformated, 0);
            this.conditionComb.select(0);
            this.removeOverHistory();
            this.setResponseTime(responseTime);
            int dispCnt = elements.length - 1;
            this.setTotalCount(dispCnt, -1L);
            RecordCountForTableJob job2 = new RecordCountForTableJob(Transaction.getInstance(this.config), this.tableNode, condition, dispCnt, doCalculate);
            job2.setUser(false);
            job2.schedule();
        }
        catch (Exception e) {
            DbPlugin.log(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void createResultPage(IDBConfig config, ITable iTable, boolean isSearch) throws NotFoundColumnInfoException {
        Object object = this.lock;
        synchronized (object) {
            TableViewEditorInput input = new TableViewEditorInput(config, iTable);
            this.setInput(input);
            this.config = config;
            if (this.viewer != null) {
                if (!isSearch) return;
            }
            String maxRecordMessage = "";
            TimeWatcher time = new TimeWatcher();
            time.start();
            boolean doCalculate = false;
            try {
                try {
                    this.elements = TableManager.invoke(config, iTable);
                }
                catch (MaxRecordException e) {
                    this.elements = e.getTableElements();
                    doCalculate = true;
                    maxRecordMessage = e.getMessage();
                }
                catch (NotFoundColumnInfoException e) {
                    throw e;
                }
                catch (SQLException e) {
                    DbPlugin.getDefault().showWarningMessage(e.getMessage());
                }
                catch (Exception e) {
                    DbPlugin.getDefault().showErrorDialog(e);
                }
            }
            catch (Throwable throwable) {
                Object var10_16 = null;
                time.stop();
                throw throwable;
            }
            {
                Object var10_17 = null;
                time.stop();
            }
            this.limit = DbPlugin.getDefault().getPreferenceStore().getInt("PreferencePage.MaxViewRecord");
            this.createMainPage();
            this.setInfomationText(maxRecordMessage);
            this.setResponseTime(time.getTotalTime());
            if (this.elements == null) return;
            TreeView view = (TreeView)DbPlugin.findView("zigen.plugin.db.ui.views.TreeView");
            LoadingColumnInfoJob job3 = new LoadingColumnInfoJob(view.getTreeViewer(), this.tableNode);
            job3.setPriority(20);
            job3.setUser(false);
            job3.schedule();
            int dispCnt = this.elements.length - 1;
            this.setTotalCount(dispCnt, -1L);
            RecordCountForTableJob job2 = new RecordCountForTableJob(Transaction.getInstance(config), iTable, null, dispCnt, doCalculate);
            job2.setPriority(30);
            job2.setUser(false);
            job2.schedule();
            return;
        }
    }

    protected void pageChange(int newPageIndex) {
        super.pageChange(newPageIndex);
    }

    public void editTableElement(Object element, int column) {
        this.viewer.cancelEditing();
        this.viewer.editElement(element, column);
    }

    public TableViewer getViewer() {
        return this.viewer;
    }

    public void setInfomationText(String text) {
        this.infoLabel.setText(text);
        this.computeSize(this.infoLabelItem);
    }

    public TableElement getHeaderTableElement() {
        Object obj = this.viewer.getInput();
        if (obj instanceof TableElement[]) {
            TableElement[] elements = (TableElement[])obj;
            if (elements.length > 0) {
                return elements[0];
            }
            return null;
        }
        return null;
    }

    public ITable getTableNode() {
        return this.tableNode;
    }

    protected void initializeViewerFont(ISourceViewer viewer) {
        StyledText styledText = viewer.getTextWidget();
        styledText.setFont(DbPlugin.getDefaultFont());
    }

    public void setFocus() {
        this.setResponseTime(this.responseTime);
        DbPlugin.fireStatusChangeListener(this.selection, 105);
        IActionBars bars = this.getEditorSite().getActionBars();
        bars.clearGlobalActionHandlers();
        switch (this.getActivePage()) {
            case 2: {
                this.tableDefineEditor.setFocus();
                break;
            }
            case 1: {
                this.setDDLString();
                this.setGlobalActionForDDL(bars);
                break;
            }
            case 0: {
                this.setGlobalActionForEditor(bars);
                if (this.conditionComb == null) break;
                this.conditionComb.setFocus();
                break;
            }
        }
        bars.updateActionBars();
        this.setStatusMessage(this.getEditorInput().getToolTipText());
    }

    void setDDLString() {
        try {
            ISQLCreatorFactory factory = AbstractSQLCreatorFactory.getFactory(this.config, this.tableNode);
            this.ddlViewer.getDocument().set(factory.createDDL());
        }
        catch (Exception e) {
            DbPlugin.log(e);
        }
    }

    void setGlobalActionForDDL(IActionBars bars) {
        bars.setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), (IAction)new GlobalAction((TextViewer)this.ddlViewer, 7));
        bars.setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)new GlobalAction((TextViewer)this.ddlViewer, 4));
        this.insertRecordAction.setEnabled(false);
    }

    void setGlobalActionForEditor(IActionBars bars) {
        bars.setGlobalActionHandler("zigen.plugin.db.actions.InsertRecordAction", (IAction)this.insertRecordAction);
        bars.setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), (IAction)this.selectAllRecordAction);
        bars.setGlobalActionHandler(ActionFactory.DELETE.getId(), (IAction)this.deleteAction);
        bars.setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)this.copyAction);
        bars.setGlobalActionHandler(ActionFactory.PASTE.getId(), (IAction)this.pasteAction);
        this.insertRecordAction.setEnabled(true);
    }

    public SourceViewer getLogViewer() {
        return this.logViewer;
    }

    protected void AddContentAssist() {
    }

    public IDBConfig getDBConfig() {
        return this.config;
    }

    private void createDefinPage() {
        Composite composite = new Composite(this.getContainer(), 0);
        composite.setLayout((Layout)new FillLayout());
        this.tableDefineEditor = new TableDefineEditor(composite, this.tableNode);
        this.tableDefineEditor.setEditor(this);
        this.tableDefineEditor.createWidget();
        int index = this.addPage((Control)composite);
        this.setPageText(index, Messages.getString("TableViewEditorFor31.28"));
    }

    public void doSave(IProgressMonitor monitor) {
        try {
            String newTableName = this.tableDefineEditor.getTableName();
            String newRemarks = this.tableDefineEditor.getTableComment();
            ModifyTableThread invoker = new ModifyTableThread(this.tableNode, newTableName, newRemarks);
            invoker.run();
            TableViewEditorInput input = (TableViewEditorInput)this.getEditorInput();
            String partName = this.tableNode.getSqlTableName();
            this.setPartName(partName);
            StringBuffer sb = new StringBuffer();
            sb.append("[");
            sb.append(input.getConfig().getDbName());
            sb.append("] ");
            sb.append(partName);
            if (this.tableNode.getRemarks() != null && !"".equals(this.tableNode.getRemarks().trim())) {
                sb.append(" [");
                sb.append(this.tableNode.getRemarks());
                sb.append("]");
            }
            input.setToolTipText(sb.toString());
            this.setStatusMessage(input.getToolTipText());
            this.setDirty(false);
        }
        catch (Exception e) {
            DbPlugin.getDefault().showErrorDialog(e);
        }
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean value) {
        this.dirty = value;
        this.firePropertyChange(257);
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void changeColumnColor(Column column) {
        this.changeColorJob.setSelectedColumn(column);
        this.changeColorJob.schedule();
    }

    public void changeColumnColor() {
        this.changeColorJob.setTable(this.table);
        this.changeColorJob.schedule();
    }

    public void selectionChanged(IWorkbenchPart part, ISelection _selection) {
        if (_selection != null && _selection instanceof StructuredSelection && part instanceof TreeView) {
            Object obj;
            TreeView tree = (TreeView)part;
            if (tree.isLinkingEnabled() && _selection.equals(this.selection)) {
                try {
                    this.getSite().getPage().openEditor(this.getEditorInput(), "zigen.plugin.db.ui.editors.TableEditor", false);
                }
                catch (PartInitException partInitException) {}
            }
            if ((obj = ((StructuredSelection)_selection).getFirstElement()) != null) {
                ITable t;
                Column column;
                if (obj instanceof Column && (column = (Column)obj).getTable().equals(this.tableNode)) {
                    this.changeColumnColor((Column)obj);
                }
                if (obj instanceof ITable && (t = (ITable)obj).equals(this.tableNode)) {
                    this.changeColumnColor(null);
                }
            }
        }
    }

    public void statusChanged(Object obj, int status) {
        ITable wk;
        if (status == 104 && obj instanceof ITable && (wk = (ITable)obj).equals(this.tableNode)) {
            try {
                while (this.isLodingColumnInfo) {
                    Thread.sleep(100L);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            int current = this.getActivePage();
            IDBConfig wkConfig = wk.getDbConfig();
            boolean isSearch = true;
            try {
                this.createResultPage(wkConfig, wk, isSearch);
            }
            catch (NotFoundColumnInfoException e) {
                e.printStackTrace();
            }
            this.setActivePage(current);
            String partName = this.tableNode.getSqlTableName();
            this.setPartName(partName);
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (this.sqlConfiguration != null && this.ddlViewer != null) {
            StyledTextUtil.changeColor(this.colorManager, this.ddlViewer.getTextWidget());
            LineNumberRulerColumnUtil.changeColor(this.colorManager, this.rulerCol);
            this.sqlConfiguration.updatePreferences(this.ddlViewer.getDocument());
            this.painter.setColor(this.colorManager.getColor("SQLEditorPreferencePage.ColorMatching"));
            this.ddlViewer.invalidateTextPresentation();
            this.isLockedColumnWidth = this.ps.getBoolean("PreferencePage.LogColumnWidth");
            if (this.pingColumnItem != null) {
                this.pingColumnItem.setSelection(this.isLockedColumnWidth);
            }
        }
    }

    public TableDefineEditor getTableDefineEditor() {
        return this.tableDefineEditor;
    }

    public String getCondition() {
        return this.whereString;
    }

    public ColumnFilterInfo[] getFilterInfos() {
        return this.filterInfos;
    }

    public void setSelection(ISelection selection) {
        this.selection = selection;
    }

    protected IStatusLineManager getIStatusLineManager() {
        IEditorSite vieweSite = super.getEditorSite();
        IActionBars actionBars = vieweSite.getActionBars();
        return actionBars.getStatusLineManager();
    }

    public void setStatusMessage(String message) {
        this.getIStatusLineManager().setMessage(message);
    }

    public void setStatusErrorMessage(String message) {
        this.getIStatusLineManager().setErrorMessage(message);
    }

    private boolean hasOrderBy() {
        SqlTokenizer tokenizer;
        SqlTokenizer it = tokenizer = new SqlTokenizer(this.whereString, DbPlugin.getSqlFormatRult());
        while (it.hasNext()) {
            Token token = (Token)it.next();
            if (token.getType() != 10 || !"order by".equalsIgnoreCase(token.getCustom())) continue;
            return true;
        }
        return false;
    }

    public String getOrderByString() {
        if (!this.hasOrderBy()) {
            TreeMap<Integer, ColumnFilterInfo> map = new TreeMap<Integer, ColumnFilterInfo>();
            int i = 0;
            while (i < this.filterInfos.length) {
                int sortNum = this.filterInfos[i].getSortNo();
                if (sortNum > 0) {
                    map.put(new Integer(sortNum), this.filterInfos[i]);
                }
                ++i;
            }
            StringBuffer sb = new StringBuffer();
            int cnt = 0;
            Iterator itr = map.keySet().iterator();
            while (itr.hasNext()) {
                Integer key = (Integer)itr.next();
                ColumnFilterInfo info = (ColumnFilterInfo)map.get(key);
                if (cnt == 0) {
                    sb.append("ORDER BY ");
                } else {
                    sb.append(", ");
                }
                sb.append(info.getColumnName());
                if (info.isDesc()) {
                    sb.append(" DESC");
                }
                ++cnt;
            }
            return sb.toString();
        }
        return null;
    }

    public void setEnabled(boolean enabled) {
        this.table.setEnabled(enabled);
        this.table.setVisible(enabled);
        this.conditionComb.setEnabled(enabled);
        this.searchItem.setEnabled(enabled);
        this.filterItem.setEnabled(enabled);
        this.pingColumnItem.setEnabled(enabled);
    }

    public int getRecordLimit() {
        return this.limit;
    }

    public int getRecordOffset() {
        return this.offset;
    }

    private void setExtensionPoint(IMenuManager manager) {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint(String.valueOf(DbPlugin.getDefault().getBundle().getSymbolicName()) + ".tableEditor");
        IExtension[] extensions = point.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] elements = extensions[i].getConfigurationElements();
            this.add(manager, elements);
            ++i;
        }
    }

    private void add(IMenuManager menu, IConfigurationElement[] elems) {
        try {
            int k = 0;
            while (k < elems.length) {
                block16: {
                    String _name;
                    IMenuManager subMenu;
                    IConfigurationElement element = elems[k];
                    String name = element.getName();
                    if ("contributor".equals(name)) {
                        try {
                            IContributionManager mgr;
                            Separator sep;
                            ITableViewEditorAction action = (ITableViewEditorAction)element.createExecutableExtension("class");
                            action.setText(element.getAttribute("label"));
                            action.setToolTipText(element.getAttribute("tooltipText"));
                            action.setActiveEditor(this);
                            action.selectionChanged(this.viewer.getSelection());
                            this.extensionList.add(action);
                            String menubarPath = element.getAttribute("menubarPath");
                            subMenu = menu.findMenuUsingPath(menubarPath);
                            if (subMenu != null) {
                                subMenu.add((IAction)action);
                                this.add(subMenu, element.getChildren());
                                break block16;
                            }
                            IContributionItem item = menu.findUsingPath(menubarPath);
                            if (item == null) break block16;
                            if (item instanceof Separator) {
                                sep = (Separator)item;
                                mgr = sep.getParent();
                                mgr.add((IAction)action);
                                this.add(subMenu, element.getChildren());
                                break block16;
                            }
                            if (item instanceof GroupMarker) {
                                sep = (GroupMarker)item;
                                mgr = sep.getParent();
                                mgr.add((IAction)action);
                                this.add(subMenu, element.getChildren());
                                break block16;
                            }
                            DbPlugin.log("unexpected Type " + item.getClass().getName());
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    } else if ("menu".equals(name)) {
                        String _id = element.getAttribute("id");
                        String _label = element.getAttribute("label");
                        subMenu = menu.findMenuUsingPath(_id);
                        if (subMenu == null) {
                            subMenu = new MenuManager(_label, _id);
                            menu.add((IContributionItem)subMenu);
                            this.add(subMenu, element.getChildren());
                        }
                    } else if ("separator".equals(name)) {
                        _name = element.getAttribute("name");
                        menu.add((IContributionItem)new Separator(_name));
                    } else if ("groupMarker".equals(name)) {
                        _name = element.getAttribute("name");
                        menu.add((IContributionItem)new GroupMarker(_name));
                    }
                }
                ++k;
            }
        }
        catch (Exception e) {
            DbPlugin.log(e);
        }
    }

    private void disposeExtensionPoint() {
        Iterator iter = this.extensionList.iterator();
        while (iter.hasNext()) {
            ITableViewEditorAction action = (ITableViewEditorAction)iter.next();
            action.setActiveEditor(null);
            Object var2_2 = null;
        }
    }

    class LoadingColumnInfoJob
    extends RefreshColumnJob {
        public LoadingColumnInfoJob(TreeViewer treeViewer, ITable table) {
            super(treeViewer, table);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected IStatus run(IProgressMonitor monitor) {
            con = null;
            try {
                try {
                    block17: {
                        TableViewEditorFor31.this.isLodingColumnInfo = true;
                        config = this.table.getDbConfig();
                        con = ConnectionManager.getConnection(config);
                        monitor.beginTask(Messages.getString("TableViewEditorFor31.0"), 10);
                        var4_7 = TableViewEditorFor31.loadingColumnInfolock;
                        synchronized (var4_7) {
                            if (this.table.isExpanded()) break block17;
                            monitor.beginTask(Messages.getString("TableViewEditorFor31.34"), 6);
                            if (super.loadColumnInfo(monitor, con, this.table)) ** break block15
                            this.table.setExpanded(false);
                            var12_8 = Status.CANCEL_STATUS;
                        }
                        var10_10 = null;
                        TableViewEditorFor31.this.isLodingColumnInfo = false;
                        ConnectionManager.closeConnection(con);
                        return var12_8;
                        {
                            this.table.setExpanded(true);
                            header = TableViewEditorFor31.this.getHeaderTableElement();
                            if (header != null) {
                                columns = header.getColumns();
                                if (columns.length != this.table.getChildrens().length) throw new IllegalStateException(Messages.getString("TableViewEditorFor31.30"));
                                col = this.table.getColumns();
                                i = 0;
                                while (i < columns.length) {
                                    column = columns[i];
                                    if (column.getColumnName().equals(col[i].getName())) {
                                        column.setDefaultValue(col[i].getDefaultValue());
                                    }
                                    ++i;
                                }
                            }
                        }
                    }
                    this.showResults(new SetEnabledAction(this.table));
                    if (monitor.isCanceled()) {
                        var12_9 = Status.CANCEL_STATUS;
                        var10_11 = null;
                        TableViewEditorFor31.this.isLodingColumnInfo = false;
                        ConnectionManager.closeConnection(con);
                        return var12_9;
                    }
                    monitor.done();
                }
                catch (NotFoundColumnInfoException e) {
                    this.table.removeChildAll();
                    this.showResults(new RefreshTreeNodeAction(this.treeViewer, this.table));
                    this.showErrorMessage(Messages.getString("TableViewEditorFor31.31"), e);
                }
                catch (NotFoundSynonymInfoException e) {
                    this.table.setEnabled(false);
                    this.table.removeChildAll();
                    this.showResults(new RefreshTreeNodeAction(this.treeViewer, this.table));
                    this.showErrorMessage(Messages.getString("TableViewEditorFor31.32"), e);
                }
                catch (Exception e) {
                    this.showErrorMessage(Messages.getString("TableViewEditorFor31.33"), e);
                }
                var10_13 = null;
                TableViewEditorFor31.this.isLodingColumnInfo = false;
            }
            catch (Throwable var11_19) {
                var10_12 = null;
                TableViewEditorFor31.this.isLodingColumnInfo = false;
                ConnectionManager.closeConnection(con);
                throw var11_19;
            }
            ConnectionManager.closeConnection(con);
            return Status.OK_STATUS;
        }

        protected class SetEnabledAction
        implements Runnable {
            ITable table;

            public SetEnabledAction(ITable table) {
                this.table = table;
            }

            public void run() {
                try {
                    IActionBars bars = TableViewEditorFor31.this.getEditorSite().getActionBars();
                    bars.clearGlobalActionHandlers();
                    Column[] columns = this.table.getColumns();
                    ColumnFilterInfo[] newfilterInfos = new ColumnFilterInfo[columns.length];
                    int i = 0;
                    while (i < columns.length) {
                        Column col = columns[i];
                        newfilterInfos[i] = new ColumnFilterInfo(col);
                        if (((LoadingColumnInfoJob)LoadingColumnInfoJob.this).TableViewEditorFor31.this.filterInfos != null) {
                            int j = 0;
                            while (j < ((LoadingColumnInfoJob)LoadingColumnInfoJob.this).TableViewEditorFor31.this.filterInfos.length) {
                                if (columns[i].getColumn().getColumnName().equals(((LoadingColumnInfoJob)LoadingColumnInfoJob.this).TableViewEditorFor31.this.filterInfos[j].getColumnName())) {
                                    newfilterInfos[i].setChecked(((LoadingColumnInfoJob)LoadingColumnInfoJob.this).TableViewEditorFor31.this.filterInfos[j].isChecked());
                                    break;
                                }
                                ++j;
                            }
                        }
                        ++i;
                    }
                    ((LoadingColumnInfoJob)LoadingColumnInfoJob.this).TableViewEditorFor31.this.filterInfos = newfilterInfos;
                    TableViewEditorFor31.this.setCellModify(TableViewEditorFor31.this.viewer, ((LoadingColumnInfoJob)LoadingColumnInfoJob.this).TableViewEditorFor31.this.filterInfos, TableViewEditorFor31.this.handler);
                    TableViewEditorFor31.this.setGlobalActionForEditor(bars);
                    TableViewEditorFor31.this.AddContentAssist();
                    if (!((LoadingColumnInfoJob)LoadingColumnInfoJob.this).TableViewEditorFor31.this.isExistDDLPage) {
                        ((LoadingColumnInfoJob)LoadingColumnInfoJob.this).TableViewEditorFor31.this.isExistDDLPage = true;
                        TableViewEditorFor31.this.createDDLPage();
                    }
                    if (!((LoadingColumnInfoJob)LoadingColumnInfoJob.this).TableViewEditorFor31.this.isExistDefinePage) {
                        ((LoadingColumnInfoJob)LoadingColumnInfoJob.this).TableViewEditorFor31.this.isExistDefinePage = true;
                        TableViewEditorFor31.this.createDefinPage();
                    }
                    TableViewEditorFor31.this.tableDefineEditor.updateWidget();
                    TableViewEditorFor31.this.setDirty(false);
                    TableViewEditorFor31.this.hookContextMenu();
                    this.setEnabled(true);
                    ((LoadingColumnInfoJob)LoadingColumnInfoJob.this).TableViewEditorFor31.this.conditionComb.setFocus();
                }
                catch (Exception e) {
                    DbPlugin.log(e);
                }
            }

            private void setEnabled(boolean b) {
                ((LoadingColumnInfoJob)LoadingColumnInfoJob.this).TableViewEditorFor31.this.conditionComb.setEnabled(b);
                ((LoadingColumnInfoJob)LoadingColumnInfoJob.this).TableViewEditorFor31.this.searchItem.setEnabled(b);
                ((LoadingColumnInfoJob)LoadingColumnInfoJob.this).TableViewEditorFor31.this.filterItem.setEnabled(b);
                ((LoadingColumnInfoJob)LoadingColumnInfoJob.this).TableViewEditorFor31.this.pingColumnItem.setEnabled(b);
                TableViewEditorFor31.this.getContributor().setEnabled(b);
                ((LoadingColumnInfoJob)LoadingColumnInfoJob.this).TableViewEditorFor31.this.addToolItem.setEnabled(b);
            }
        }
    }
}

