/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.ui.actions.Messages;
import zigen.plugin.db.ui.dialogs.DBConfigWizard;
import zigen.plugin.db.ui.internal.Bookmark;
import zigen.plugin.db.ui.internal.BookmarkFolder;
import zigen.plugin.db.ui.internal.BookmarkRoot;
import zigen.plugin.db.ui.internal.DataBase;
import zigen.plugin.db.ui.internal.TreeLeaf;
import zigen.plugin.db.ui.views.TreeContentProvider;

public class EditDBAction
extends Action
implements Runnable {
    TreeViewer viewer = null;

    public EditDBAction(TreeViewer viewer) {
        this.viewer = viewer;
        this.setText(Messages.getString("EditDBAction.0"));
        this.setToolTipText(Messages.getString("EditDBAction.1"));
        this.setEnabled(true);
        this.setImageDescriptor(DbPlugin.getDefault().getImageDescriptor("db_edit.gif"));
    }

    public void run() {
        Object element = ((StructuredSelection)this.viewer.getSelection()).getFirstElement();
        if (element instanceof DataBase) {
            DBConfigWizard wizard;
            DataBase db = (DataBase)element;
            DataBase oldDB = (DataBase)db.clone();
            Shell shell = DbPlugin.getDefault().getShell();
            WizardDialog dialog2 = new WizardDialog(shell, (IWizard)(wizard = new DBConfigWizard(this.viewer.getSelection(), db.getDbConfig())));
            int ret = dialog2.open();
            if (ret == 0) {
                IDBConfig newConfig = wizard.getNewConfig();
                db.setDbConfig(newConfig);
                this.viewer.refresh((Object)db);
                IContentProvider cp = this.viewer.getContentProvider();
                if (cp instanceof TreeContentProvider) {
                    TreeContentProvider tcp = (TreeContentProvider)cp;
                    BookmarkRoot bmroot = tcp.getBookmarkRoot();
                    this.updateBookmark(bmroot, oldDB, db);
                }
                this.viewer.getControl().notifyListeners(13, null);
                DbPlugin.fireStatusChangeListener(newConfig, 200);
                DbPlugin.fireStatusChangeListener(this.viewer, 107);
            }
        }
    }

    private void updateBookmark(BookmarkFolder folder, DataBase targetDataBase, DataBase newDataBase) {
        TreeLeaf[] leafs = folder.getChildrens();
        int i = 0;
        while (i < leafs.length) {
            TreeLeaf leaf = leafs[i];
            if (leaf instanceof Bookmark) {
                Bookmark bm = (Bookmark)leaf;
                if (bm.getDataBase().equals(targetDataBase)) {
                    bm.setDataBase(newDataBase);
                }
            } else if (leaf instanceof BookmarkFolder) {
                this.updateBookmark((BookmarkFolder)leaf, targetDataBase, newDataBase);
            }
            ++i;
        }
    }
}

