/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.actions;

import java.util.Iterator;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.ui.actions.Messages;
import zigen.plugin.db.ui.internal.DataBase;
import zigen.plugin.db.ui.jobs.ConnectDBJob;

public class ConnectDBAction
extends Action
implements Runnable {
    TreeViewer viewer = null;

    public ConnectDBAction(TreeViewer viewer) {
        this.viewer = viewer;
        this.setText(Messages.getString("ConnectDBAction.0"));
        this.setToolTipText(Messages.getString("ConnectDBAction.1"));
        this.setEnabled(true);
    }

    public void run() {
        try {
            IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
            Iterator iter = selection.iterator();
            while (iter.hasNext()) {
                DataBase db;
                Object element = iter.next();
                if (!(element instanceof DataBase) || (db = (DataBase)element).isConnected()) continue;
                db.setConnected(true);
                ConnectDBJob job = new ConnectDBJob(this.viewer, db);
                job.setPriority(20);
                job.setUser(false);
                job.setSystem(false);
                job.schedule();
            }
        }
        catch (Exception e) {
            DbPlugin.log(e);
        }
    }
}

