/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ext.oracle.internal;

import java.sql.Connection;
import org.eclipse.jface.viewers.StructuredViewer;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.DbPluginConstant;
import zigen.plugin.db.core.Transaction;
import zigen.plugin.db.ext.oracle.internal.OracleSourceTypeSearcher;
import zigen.plugin.db.ui.internal.Folder;
import zigen.plugin.db.ui.internal.OracleSource;
import zigen.plugin.db.ui.internal.Schema;

public class SourceTypeSearchAction
implements Runnable {
    StructuredViewer viewer;
    Schema schema;

    public SourceTypeSearchAction(StructuredViewer viewer, Schema schema) {
        this.viewer = viewer;
        this.schema = schema;
    }

    public void run() {
        try {
            Connection con = Transaction.getInstance(this.schema.getDbConfig()).getConnection();
            String owner = this.schema.getName();
            String[] sourceTypes = OracleSourceTypeSearcher.execute(con, owner);
            this.schema.setSourceType(sourceTypes);
            int i = 0;
            while (i < sourceTypes.length) {
                String stype = sourceTypes[i];
                Folder folder = new Folder(stype);
                OracleSource source = new OracleSource();
                source.setName(DbPluginConstant.TREE_LEAF_LOADING);
                folder.addChild(source);
                this.schema.addChild(folder);
                ++i;
            }
            this.viewer.refresh((Object)this.schema);
        }
        catch (Exception e) {
            DbPlugin.getDefault().showErrorDialog(e);
        }
    }
}

