/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.diff;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.progress.IProgressConstants;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.DbPluginConstant;
import zigen.plugin.db.core.ConnectionManager;
import zigen.plugin.db.core.DBType;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.core.TableColumn;
import zigen.plugin.db.core.TableConstraintColumn;
import zigen.plugin.db.core.TableFKColumn;
import zigen.plugin.db.core.TableIDXColumn;
import zigen.plugin.db.core.TableInfo;
import zigen.plugin.db.core.TablePKColumn;
import zigen.plugin.db.core.TableSearcher;
import zigen.plugin.db.core.rule.DefaultColumnSearcherFactory;
import zigen.plugin.db.core.rule.DefaultConstraintSearcherFactory;
import zigen.plugin.db.core.rule.IColumnSearcherFactory;
import zigen.plugin.db.core.rule.IConstraintSearcherFactory;
import zigen.plugin.db.diff.DDL;
import zigen.plugin.db.diff.DDLDiff;
import zigen.plugin.db.diff.DDLDiffEditor;
import zigen.plugin.db.diff.DDLDiffEditorInput;
import zigen.plugin.db.diff.DDLNode;
import zigen.plugin.db.diff.IDDL;
import zigen.plugin.db.diff.IDDLDiff;
import zigen.plugin.db.diff.Messages;
import zigen.plugin.db.diff.SourceDDL;
import zigen.plugin.db.diff.SourceDDLDiff;
import zigen.plugin.db.ext.oracle.internal.OracleIndexSearcher;
import zigen.plugin.db.ext.oracle.internal.OracleSourceInfo;
import zigen.plugin.db.ext.oracle.internal.OracleSourceSearcher;
import zigen.plugin.db.ext.oracle.internal.OracleSynonymInfoSearcher;
import zigen.plugin.db.ext.oracle.internal.SynonymInfo;
import zigen.plugin.db.ui.editors.exceptions.NotFoundSynonymInfoException;
import zigen.plugin.db.ui.internal.Bookmark;
import zigen.plugin.db.ui.internal.Column;
import zigen.plugin.db.ui.internal.Folder;
import zigen.plugin.db.ui.internal.ITable;
import zigen.plugin.db.ui.internal.OracleColumn;
import zigen.plugin.db.ui.internal.OracleSource;
import zigen.plugin.db.ui.internal.Schema;
import zigen.plugin.db.ui.internal.Synonym;
import zigen.plugin.db.ui.internal.TreeLeaf;
import zigen.plugin.db.ui.jobs.AbstractJob;
import zigen.plugin.db.ui.views.TableSearchThread;

public class DDLDiffForSchemaJob
extends AbstractJob {
    public static final String TargetFolderPattern = "^TABLE|^VIEW|^SYNONYM|^ALIAS";
    public static final String TargetFolderPattern2 = "^FUNCTION|^PROCEDURE|^PACKAGE";
    private TreeViewer viewer;
    private List allTables = new ArrayList();
    private List ddlList = new ArrayList();
    private Map map1 = new HashMap();
    private Map map2 = new HashMap();
    private Schema s1;
    private Schema s2;

    public DDLDiffForSchemaJob(TreeViewer viewer, Schema s1, Schema s2) {
        super(Messages.getString("DDLDiffJob.0"));
        this.s1 = s1;
        this.s2 = s2;
        this.viewer = viewer;
    }

    protected IStatus run(IProgressMonitor monitor) {
        IStatus result = Status.OK_STATUS;
        try {
            this.setProperty(IProgressConstants.ICON_PROPERTY, null);
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            Schema schema1 = (Schema)this.s1.clone();
            schema1.setParent(this.s1.getParent());
            Schema schema2 = (Schema)this.s2.clone();
            schema2.setParent(this.s2.getParent());
            if (this.loadAll(monitor, schema1, this.map1) != Status.OK_STATUS) {
                return Status.CANCEL_STATUS;
            }
            result = this.loadAll(monitor, schema2, this.map2);
            Collections.sort(this.allTables);
            Iterator iter = this.allTables.iterator();
            while (iter.hasNext()) {
                DDLNode diff;
                IDDL ddl1;
                if (monitor.isCanceled()) break;
                String keyword = (String)iter.next();
                Object obj1 = this.map1.get(keyword);
                Object obj2 = this.map2.get(keyword);
                if (obj1 != null && obj2 != null) {
                    DDLNode diff2;
                    IDDL ddl2;
                    if (obj1 instanceof DDL && obj2 instanceof DDL) {
                        ddl1 = (DDL)obj1;
                        ddl2 = (DDL)obj2;
                        diff2 = new DDLDiff((DDL)ddl1, (DDL)ddl2);
                        this.ddlList.add(diff2);
                        continue;
                    }
                    if (!(obj1 instanceof SourceDDL) || !(obj2 instanceof SourceDDL)) continue;
                    ddl1 = (SourceDDL)obj1;
                    ddl2 = (SourceDDL)obj2;
                    diff2 = new SourceDDLDiff((SourceDDL)ddl1, (SourceDDL)ddl2);
                    this.ddlList.add(diff2);
                    continue;
                }
                if (obj1 == null) {
                    IDDL ddl2;
                    if (obj2 instanceof DDL) {
                        ddl2 = (DDL)obj2;
                        diff = new DDLDiff(null, (DDL)ddl2);
                        this.ddlList.add(diff);
                        continue;
                    }
                    if (!(obj2 instanceof SourceDDL)) continue;
                    ddl2 = (SourceDDL)obj2;
                    diff = new SourceDDLDiff(null, (SourceDDL)ddl2);
                    this.ddlList.add(diff);
                    continue;
                }
                if (obj2 != null) continue;
                if (obj1 instanceof DDL) {
                    ddl1 = (DDL)obj1;
                    diff = new DDLDiff((DDL)ddl1, null);
                    this.ddlList.add(diff);
                    continue;
                }
                if (!(obj1 instanceof SourceDDL)) continue;
                ddl1 = (SourceDDL)obj1;
                diff = new SourceDDLDiff((SourceDDL)ddl1, null);
                this.ddlList.add(diff);
            }
            monitor.done();
            this.showResults(new ShowDiffView());
        }
        catch (Exception e) {
            DbPlugin.log(e);
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IStatus loadAll(IProgressMonitor monitor, Schema schema, Map map) {
        Connection con;
        block32: {
            IStatus iStatus;
            block29: {
                IStatus iStatus2;
                block28: {
                    con = null;
                    try {
                        try {
                            IDBConfig config = schema.getDbConfig();
                            con = ConnectionManager.getConnection(config);
                            schema.setExpanded(true);
                            String[] tableTypes = schema.getDataBase().getTableType();
                            int i = 0;
                            while (i < tableTypes.length) {
                                block35: {
                                    Folder folder;
                                    String currentType;
                                    int totalWork;
                                    block34: {
                                        block33: {
                                            if (monitor.isCanceled()) {
                                                iStatus2 = Status.CANCEL_STATUS;
                                                Object var19_26 = null;
                                                break block28;
                                            }
                                            totalWork = 0;
                                            currentType = tableTypes[i];
                                            String[] types = new String[]{currentType};
                                            if (!currentType.toUpperCase().matches(TargetFolderPattern)) break block33;
                                            TableInfo[] tables = TableSearcher.execute(con, schema.getName(), types);
                                            TableSearchThread.addFolderAndTables(con, schema, currentType, tables);
                                            totalWork += tables.length;
                                            break block34;
                                        }
                                        if (!currentType.toUpperCase().matches(TargetFolderPattern2)) break block35;
                                        if (DBType.getType(config) == 1) {
                                            try {
                                                OracleSourceInfo[] infos = OracleSourceSearcher.execute(con, schema.getName(), currentType);
                                                totalWork += infos.length;
                                                folder = (Folder)schema.getChild(currentType);
                                                if (folder == null) {
                                                    folder = new Folder(currentType);
                                                    schema.addChild(folder);
                                                }
                                                int j = 0;
                                                while (j < infos.length) {
                                                    OracleSource source = new OracleSource();
                                                    source.setOracleSourceInfo(infos[j]);
                                                    folder.addChild(source);
                                                    ++j;
                                                }
                                            }
                                            catch (RuntimeException e) {
                                                e.printStackTrace();
                                            }
                                        }
                                    }
                                    monitor.beginTask(String.valueOf(config.getDbName()) + "/" + schema.getName() + Messages.getString("DDLDiffJob.1") + tableTypes[i] + Messages.getString("DDLDiffJob.2"), totalWork);
                                    TreeLeaf leaf = schema.getChild(currentType);
                                    if (leaf instanceof Folder) {
                                        folder = (Folder)leaf;
                                        folder.setExpanded(true);
                                        List list = folder.getChildren();
                                        Iterator iter = list.iterator();
                                        while (iter.hasNext()) {
                                            block31: {
                                                if (monitor.isCanceled()) {
                                                    iStatus = Status.CANCEL_STATUS;
                                                    break block29;
                                                }
                                                try {
                                                    String key;
                                                    IDDL ddl;
                                                    Object obj = iter.next();
                                                    if (obj instanceof ITable) {
                                                        ITable table = (ITable)obj;
                                                        monitor.subTask("Target:" + table.getName());
                                                        if (!table.isExpanded()) {
                                                            table.removeChild(table.getChild(DbPluginConstant.TREE_LEAF_LOADING));
                                                            table.setExpanded(true);
                                                            try {
                                                                if (DBType.getType(config) == 1) {
                                                                    if (table.getName().indexOf("BIN$") >= 0) continue;
                                                                    this.loadColumn(monitor, con, table, config.isConvertUnicode());
                                                                } else {
                                                                    this.loadColumn(monitor, con, table, config.isConvertUnicode());
                                                                }
                                                            }
                                                            catch (NotFoundSynonymInfoException e) {
                                                                DbPlugin.log(e);
                                                            }
                                                        }
                                                        ddl = new DDL(table);
                                                        key = String.valueOf(currentType) + "@" + table.getName();
                                                        if (!this.allTables.contains(key)) {
                                                            this.allTables.add(key);
                                                        }
                                                        map.put(key, ddl);
                                                        break block31;
                                                    }
                                                    if (obj instanceof OracleSource) {
                                                        OracleSource os = (OracleSource)obj;
                                                        monitor.subTask("Target:" + os.getName());
                                                        ddl = new SourceDDL(os);
                                                        key = String.valueOf(currentType) + "@" + os.getName();
                                                        if (!this.allTables.contains(key)) {
                                                            this.allTables.add(key);
                                                        }
                                                        map.put(key, ddl);
                                                    }
                                                }
                                                catch (RuntimeException e1) {
                                                    e1.printStackTrace();
                                                }
                                            }
                                            monitor.worked(1);
                                        }
                                    }
                                }
                                ++i;
                            }
                            break block32;
                        }
                        catch (Exception e) {
                            DbPlugin.getDefault().showErrorDialog(e);
                            break block32;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var19_28 = null;
                        ConnectionManager.closeConnection(con);
                        throw throwable;
                    }
                }
                ConnectionManager.closeConnection(con);
                return iStatus2;
            }
            Object var19_27 = null;
            ConnectionManager.closeConnection(con);
            return iStatus;
        }
        Object var19_29 = null;
        ConnectionManager.closeConnection(con);
        return Status.OK_STATUS;
    }

    private void loadColumn(IProgressMonitor monitor, Connection con, ITable table, boolean convertUnicode) throws Exception {
        TablePKColumn[] pks = null;
        TableFKColumn[] fks = null;
        TableConstraintColumn[] cons = null;
        TableIDXColumn[] uidxs = null;
        TableIDXColumn[] nonuidxs = null;
        String schemaName = table.getSchemaName();
        String tableName = table.getName();
        switch (DBType.getType(con.getMetaData())) {
            case 1: {
                Bookmark bm;
                if (table.getName().toUpperCase().indexOf("BIN$") >= 0) {
                    return;
                }
                if (table instanceof Synonym) {
                    Synonym synonym = (Synonym)table;
                    schemaName = synonym.getTable_owner();
                    tableName = synonym.getTable_name();
                    break;
                }
                if (!(table instanceof Bookmark) || !(bm = (Bookmark)table).isSynonym()) break;
                SynonymInfo info = OracleSynonymInfoSearcher.execute(con, bm.getSchemaName(), bm.getName());
                schemaName = info.getTable_owner();
                tableName = info.getTable_name();
            }
        }
        IDBConfig config = table.getDbConfig();
        IColumnSearcherFactory factory = DefaultColumnSearcherFactory.getFactory(con.getMetaData(), config.isConvertUnicode());
        TableColumn[] columns = factory.execute(con, schemaName, tableName);
        IConstraintSearcherFactory constraintSearcherFactory = DefaultConstraintSearcherFactory.getFactory(config);
        pks = constraintSearcherFactory.getPKColumns(con, schemaName, tableName);
        fks = constraintSearcherFactory.getFKColumns(con, schemaName, tableName);
        if (!table.getFolderName().equals("VIEW")) {
            switch (DBType.getType(con.getMetaData())) {
                case 1: {
                    cons = constraintSearcherFactory.getConstraintColumns(con, schemaName, tableName);
                    uidxs = OracleIndexSearcher.getIDXColumns(con, schemaName, tableName, true);
                    nonuidxs = OracleIndexSearcher.getIDXColumns(con, schemaName, tableName, false);
                    break;
                }
                default: {
                    uidxs = constraintSearcherFactory.getUniqueIDXColumns(con, schemaName, tableName, true);
                    nonuidxs = constraintSearcherFactory.getUniqueIDXColumns(con, schemaName, tableName, false);
                }
            }
        }
        table.setTablePKColumns(pks);
        table.setTableFKColumns(fks);
        table.setTableConstraintColumns(cons);
        table.setTableUIDXColumns(uidxs);
        table.setTableNonUIDXColumns(nonuidxs);
        int i = 0;
        while (i < columns.length) {
            TableColumn w_column = columns[i];
            TablePKColumn w_pk = this.getPKColumn(pks, w_column);
            TableFKColumn[] w_fks = this.getFKColumns(fks, w_column);
            this.addChild(con, table, w_column, w_pk, w_fks);
            ++i;
        }
    }

    private void addChild(Connection con, ITable table, TableColumn w_column, TablePKColumn w_pk, TableFKColumn[] w_fks) throws Exception {
        switch (DBType.getType(con.getMetaData())) {
            case 1: {
                table.addChild(new OracleColumn(w_column, w_pk, w_fks));
                break;
            }
            default: {
                table.addChild(new Column(w_column, w_pk, w_fks));
            }
        }
    }

    private TablePKColumn getPKColumn(TablePKColumn[] pks, TableColumn column) throws Exception {
        TablePKColumn pk = null;
        int i = 0;
        while (i < pks.length) {
            if (pks[i].getColumnName().equals(column.getColumnName())) {
                pk = pks[i];
                break;
            }
            ++i;
        }
        return pk;
    }

    private TableFKColumn[] getFKColumns(TableFKColumn[] fks, TableColumn column) throws Exception {
        ArrayList<TableFKColumn> list = new ArrayList<TableFKColumn>();
        int i = 0;
        while (i < fks.length) {
            if (fks[i].getColumnName().equals(column.getColumnName())) {
                list.add(fks[i]);
            }
            ++i;
        }
        return list.toArray(new TableFKColumn[0]);
    }

    public class ShowDiffView
    implements Runnable {
        public void run() {
            try {
                IDDLDiff[] diffs = DDLDiffForSchemaJob.this.ddlList.toArray(new IDDLDiff[0]);
                DDLDiffEditorInput input = new DDLDiffEditorInput(diffs, false);
                IWorkbenchPage page = DbPlugin.getDefault().getPage();
                IEditorPart editor = IDE.openEditor((IWorkbenchPage)page, (IEditorInput)input, (String)"zigen.plugin.db.diff.DDLDiffEditor", (boolean)true);
                if (editor instanceof DDLDiffEditor) {
                    DDLDiffEditor cfr_ignored_0 = (DDLDiffEditor)editor;
                }
            }
            catch (Exception e) {
                DbPlugin.log(e);
            }
        }
    }
}

