/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.core;

import java.sql.DatabaseMetaData;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.core.Messages;

public class DBType {
    public static final int DB_TYPE_UNKNOWN = -1;
    public static final int DB_TYPE_ORACLE = 1;
    public static final int DB_TYPE_MYSQL = 2;
    public static final int DB_TYPE_SYMFOWARE = 3;
    public static final int DB_TYPE_HIRDB = 4;
    public static final int DB_TYPE_SYBASE = 5;
    public static final int DB_TYPE_DERBY = 6;
    public static final int DB_TYPE_SQLITE = 7;
    public static final int DB_TYPE_H2 = 8;
    public static final int DB_TYPE_POSTGRESQL = 9;
    public static final int DB_TYPE_DB2 = 10;
    public static final int DB_TYPE_SQLSERVER = 11;
    public static final int DB_TYPE_HSQLDB = 12;
    public static final int DB_TYPE_INTERBASE = 13;

    public static final int getType(IDBConfig config) {
        return DBType.getType(config.getDriverName());
    }

    public static final int getType(DatabaseMetaData objMet) {
        try {
            return DBType.getType(objMet.getDriverName());
        }
        catch (Exception exception) {
            throw new IllegalStateException(Messages.getString("DBType.0"));
        }
    }

    public static final int getType(String driverName) {
        if ((driverName = driverName.toLowerCase()).indexOf("oracle") >= 0) {
            return 1;
        }
        if (driverName.indexOf("symfoware") >= 0) {
            return 3;
        }
        if (driverName.indexOf("mysql") >= 0) {
            return 2;
        }
        if (driverName.indexOf("hirdb") >= 0) {
            return 4;
        }
        if (driverName.indexOf("sybase") >= 0) {
            return 5;
        }
        if (driverName.indexOf("derby") >= 0) {
            return 6;
        }
        if (driverName.indexOf("sqlite") >= 0) {
            return 7;
        }
        if (driverName.indexOf("h2") >= 0) {
            return 8;
        }
        if (driverName.indexOf("postgresql") >= 0) {
            return 9;
        }
        if (driverName.indexOf("db2") >= 0) {
            return 10;
        }
        if (driverName.indexOf("sqlserver") >= 0) {
            return 11;
        }
        if (driverName.indexOf("hsqldb") >= 0) {
            return 12;
        }
        if (driverName.indexOf("interbase") >= 0) {
            return 13;
        }
        return -1;
    }
}

