/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.views;

import java.sql.Connection;
import org.eclipse.jface.viewers.StructuredViewer;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.DbPluginConstant;
import zigen.plugin.db.core.DBType;
import zigen.plugin.db.core.SchemaSearcher;
import zigen.plugin.db.core.TableColumn;
import zigen.plugin.db.core.TableInfo;
import zigen.plugin.db.core.TableSearcher;
import zigen.plugin.db.core.Transaction;
import zigen.plugin.db.ext.oracle.internal.OracleSynonymInfoSearcher;
import zigen.plugin.db.ext.oracle.internal.SynonymInfo;
import zigen.plugin.db.ui.internal.Column;
import zigen.plugin.db.ui.internal.Folder;
import zigen.plugin.db.ui.internal.Schema;
import zigen.plugin.db.ui.internal.Synonym;
import zigen.plugin.db.ui.internal.Table;
import zigen.plugin.db.ui.internal.TreeNode;
import zigen.plugin.db.ui.internal.View;
import zigen.plugin.db.ui.views.Messages;

public class TableSearchThread
implements Runnable {
    StructuredViewer viewer;
    Folder folder;

    public TableSearchThread(StructuredViewer viewer, Folder folder) {
        this.viewer = viewer;
        this.folder = folder;
    }

    public void run() {
        TableInfo[] tables = null;
        try {
            Connection con = Transaction.getInstance(this.folder.getDbConfig()).getConnection();
            tables = SchemaSearcher.isSupport(con) ? TableSearcher.execute(con, this.folder.getSchema().getName(), new String[]{this.folder.getName()}) : TableSearcher.execute(con, null, new String[]{this.folder.getName()});
            TableSearchThread.AddTables(con, this.folder.getSchema(), this.folder, tables);
            this.viewer.refresh((Object)this.folder);
        }
        catch (Exception e) {
            DbPlugin.getDefault().showErrorDialog(e);
        }
    }

    public static void addFolderAndTables(Connection con, TreeNode parent, String label, TableInfo[] tables) throws Exception {
        Folder folder = new Folder(label);
        if (parent instanceof Schema) {
            TableSearchThread.AddTables(con, (Schema)parent, folder, tables);
        } else {
            TableSearchThread.AddTables(con, null, folder, tables);
        }
        parent.addChild(folder);
    }

    public static void AddTables(Connection con, Schema schema, Folder folder, TableInfo[] tables) throws Exception {
        String label = folder.getName();
        int i = 0;
        while (i < tables.length) {
            Table node;
            TableInfo tableinfo = tables[i];
            if ("SYNONYM".equals(label)) {
                node = new Synonym(tableinfo.getName(), tableinfo.getComment());
                switch (DBType.getType(con.getMetaData())) {
                    case 1: {
                        if (schema != null) {
                            String owner = schema.getName();
                            String synonymName = tableinfo.getName();
                            SynonymInfo info = OracleSynonymInfoSearcher.execute(con, owner, synonymName);
                            ((Synonym)node).setSynonymInfo(info);
                            break;
                        }
                        throw new Exception(Messages.getString("TableSearchThread.1"));
                    }
                }
            } else {
                node = "VIEW".equals(label) ? new View(tableinfo.getName(), tableinfo.getComment()) : new Table(tableinfo.getName(), tableinfo.getComment());
            }
            folder.addChild(node);
            TableColumn tColumn = new TableColumn();
            tColumn.setColumnName(DbPluginConstant.TREE_LEAF_LOADING);
            node.addChild(new Column(tColumn));
            ++i;
        }
    }
}

