/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.editors.sql;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.jface.text.source.LineNumberRulerColumn;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.core.StringUtil;
import zigen.plugin.db.ext.oracle.internal.OracleSequenceInfo;
import zigen.plugin.db.ui.editors.sql.SequenceEditorInput;
import zigen.plugin.db.ui.util.LineNumberRulerColumnUtil;
import zigen.plugin.db.ui.util.StyledTextUtil;
import zigen.plugin.db.ui.views.internal.ColorManager;
import zigen.plugin.db.ui.views.internal.PLSQLCodeConfiguration;
import zigen.plugin.db.ui.views.internal.SQLDocument;

public class SequenceEditor
extends EditorPart
implements IPropertyChangeListener {
    private final String LINE_SEP = System.getProperty("line.separator");
    protected IDBConfig config;
    protected SourceViewer sqlViewer;
    private OracleSequenceInfo sequenceInfo;
    protected LineNumberRulerColumn rulerCol;
    protected PLSQLCodeConfiguration sqlConfiguration;
    protected ColorManager colorManager = new ColorManager();
    protected IPreferenceStore store;
    protected boolean dirty = false;
    protected Text errorText;
    protected SashForm sash;

    public SequenceEditor() {
        this.sqlConfiguration = new PLSQLCodeConfiguration(this.colorManager);
        this.store = DbPlugin.getDefault().getPreferenceStore();
        this.store.addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public void createPartControl(Composite parent) {
        this.sash = new SashForm(parent, 512);
        CompositeRuler ruler = new CompositeRuler();
        LineNumberRulerColumn rulerCol = new LineNumberRulerColumn();
        LineNumberRulerColumnUtil.changeColor(this.colorManager, rulerCol);
        ruler.addDecorator(0, (IVerticalRulerColumn)rulerCol);
        this.sqlViewer = new SourceViewer((Composite)this.sash, (IVerticalRuler)ruler, 2818);
        this.initializeViewerFont((ISourceViewer)this.sqlViewer);
        this.sqlViewer.configure((SourceViewerConfiguration)this.sqlConfiguration);
        SQLDocument doc = new SQLDocument();
        this.sqlViewer.setDocument((IDocument)doc);
        this.sqlViewer.getDocument().set(this.getDDL());
        this.sqlViewer.setEditable(false);
        this.errorText = new Text((Composite)this.sash, 2);
        this.errorText.setEditable(false);
        Color white = Display.getCurrent().getSystemColor(1);
        Color red = Display.getCurrent().getSystemColor(3);
        this.errorText.setBackground(white);
        this.errorText.setForeground(red);
        int[] nArray = new int[2];
        nArray[0] = 100;
        this.sash.setWeights(nArray);
    }

    public void init(IEditorSite site, IEditorInput editorInput) throws PartInitException {
        try {
            this.setSite((IWorkbenchPartSite)site);
            this.setInput(editorInput);
            if (editorInput instanceof SequenceEditorInput) {
                SequenceEditorInput input = (SequenceEditorInput)editorInput;
                this.sequenceInfo = input.getSequenceInfo();
                this.config = input.getConfig();
                this.setPartName(input.getName());
            }
        }
        catch (Exception e) {
            DbPlugin.getDefault().showErrorDialog(e);
        }
    }

    private String getDDL() {
        StringBuffer sb = new StringBuffer();
        sb.append("CREATE");
        sb.append(" SEQUENCE ");
        if (StringUtil.isNumeric(this.sequenceInfo.getSequece_owner())) {
            sb.append("\"");
            sb.append(this.sequenceInfo.getSequece_owner());
            sb.append("\"");
        } else {
            sb.append(this.sequenceInfo.getSequece_owner());
        }
        sb.append(".");
        sb.append(this.sequenceInfo.getSequence_name());
        sb.append(this.LINE_SEP);
        sb.append("     INCREMENT BY " + this.sequenceInfo.getIncrement_by());
        sb.append(this.LINE_SEP);
        sb.append("     START WITH " + this.sequenceInfo.getLast_number());
        sb.append(this.LINE_SEP);
        sb.append("     MAXVALUE " + this.sequenceInfo.getMax_value());
        sb.append(this.LINE_SEP);
        sb.append("     MINVALUE " + this.sequenceInfo.getMin_value());
        sb.append(this.LINE_SEP);
        if ("Y".equals(this.sequenceInfo.getCycle_flg())) {
            sb.append("     CYCLE ");
        } else {
            sb.append("     NOCYCLE ");
        }
        sb.append(this.LINE_SEP);
        sb.append("     CACHE ");
        sb.append(this.sequenceInfo.getCache_size());
        sb.append(this.LINE_SEP);
        if ("Y".equals(this.sequenceInfo.getOrder_flg())) {
            sb.append("     ORDER ");
        } else {
            sb.append("     NOORDER ");
        }
        sb.append(this.LINE_SEP);
        return sb.toString();
    }

    protected void initializeViewerFont(ISourceViewer viewer) {
        StyledText styledText = viewer.getTextWidget();
        styledText.setFont(DbPlugin.getDefaultFont());
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (this.sqlConfiguration != null && this.sqlViewer != null) {
            this.sqlConfiguration.updatePreferences(this.sqlViewer.getDocument());
            StyledTextUtil.changeColor(this.colorManager, this.sqlViewer.getTextWidget());
            this.sqlViewer.invalidateTextPresentation();
        }
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void setFocus() {
    }

    public void dispose() {
        super.dispose();
        this.colorManager.dispose();
        DbPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
    }
}

