/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.dialogs;

import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.core.DBConfig;
import zigen.plugin.db.core.DBConfigManager;
import zigen.plugin.db.core.DriverManager;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.core.SameDbNameException;
import zigen.plugin.db.ui.dialogs.Messages;
import zigen.plugin.db.ui.dialogs.WizardPage1;
import zigen.plugin.db.ui.dialogs.WizardPage2;
import zigen.plugin.db.ui.dialogs.WizardPage3;
import zigen.plugin.db.ui.internal.Bookmark;
import zigen.plugin.db.ui.internal.BookmarkFolder;
import zigen.plugin.db.ui.internal.BookmarkRoot;
import zigen.plugin.db.ui.internal.DataBase;
import zigen.plugin.db.ui.internal.Root;
import zigen.plugin.db.ui.internal.TreeLeaf;

public class DBConfigWizard
extends Wizard {
    IDBConfig oldConfig;
    IDBConfig newConfig;
    private WizardPage1 page1;
    private WizardPage2 page2;
    private WizardPage3 page3;
    private ISelection selection;

    public DBConfigWizard(ISelection selection) {
        this(selection, null);
    }

    public DBConfigWizard(ISelection selection, IDBConfig oldConfig) {
        super.setWindowTitle(Messages.getString("DBConfigWizard.0"));
        this.selection = selection;
        this.oldConfig = oldConfig;
        this.setNeedsProgressMonitor(true);
        this.setHelpAvailable(false);
    }

    public void addPages() {
        this.page1 = new WizardPage1(this.selection);
        this.page2 = new WizardPage2(this.selection);
        this.page3 = new WizardPage3(this.selection);
        this.addPage((IWizardPage)this.page1);
        this.addPage((IWizardPage)this.page2);
        this.addPage((IWizardPage)this.page3);
        if (this.oldConfig != null) {
            this.page3.filterSchemas = this.oldConfig.getDisplayedSchemas();
            this.page3.checkFilterPattern = this.oldConfig.isCheckFilterPattern();
            this.page3.filterPattern = this.oldConfig.getFilterPattern() == null ? "" : this.oldConfig.getFilterPattern();
        }
    }

    public boolean performFinish() {
        try {
            this.newConfig = this.createNewConfig();
            if (this.oldConfig == null) {
                DBConfigManager.save(this.newConfig);
            } else {
                Object element;
                if (this.selection instanceof StructuredSelection && (element = ((StructuredSelection)this.selection).getFirstElement()) instanceof DataBase) {
                    DataBase _db = (DataBase)element;
                    Root root = (Root)_db.getParent().getParent();
                    List children = root.getChildren();
                    Iterator iterator = children.iterator();
                    while (iterator.hasNext()) {
                        Object obj = iterator.next();
                        if (!(obj instanceof BookmarkRoot)) continue;
                        this.changeDataBase((BookmarkRoot)obj, _db, this.newConfig);
                        break;
                    }
                }
                DBConfigManager.modify(this.oldConfig, this.newConfig);
            }
            DriverManager.getInstance().removeCach(this.newConfig);
            DbPlugin.getDefault().saveDBDialogSettings();
            return true;
        }
        catch (SameDbNameException e) {
            DbPlugin.getDefault().showWarningMessage(e.getMessage());
        }
        catch (Exception e) {
            DbPlugin.getDefault().showErrorDialog(e);
        }
        return false;
    }

    private void changeDataBase(BookmarkFolder folder, DataBase targetDataBase, IDBConfig newConfig) {
        TreeLeaf[] leafs = folder.getChildrens();
        int i = 0;
        while (i < leafs.length) {
            TreeLeaf leaf = leafs[i];
            if (leaf instanceof Bookmark) {
                Bookmark bm = (Bookmark)leaf;
                if (bm.getDataBase().equals(targetDataBase)) {
                    bm.setDbConfig(newConfig);
                }
            } else if (leaf instanceof BookmarkFolder) {
                this.changeDataBase((BookmarkFolder)leaf, targetDataBase, newConfig);
            }
            ++i;
        }
    }

    public boolean canFinish() {
        return this.page1.isPageComplete() && this.page2.isPageComplete() && this.page3.isPageComplete();
    }

    protected IDBConfig createNewConfig() {
        DBConfig config = new DBConfig();
        try {
            int index;
            config.setDbName(this.page1.nameText.getText());
            config.setClassPaths(this.page1.classpathList.toArray(new String[0]));
            config.setDriverName(this.page2.driverCombox.getText());
            config.setUrl(this.page2.urlText.getText());
            config.setUserId(this.page2.userIdText.getText());
            config.setSchema(this.page2.schemaText.getText());
            config.setPassword(this.page2.passwordText.getText());
            if (this.page2.radio2.getSelection()) {
                config.setJdbcType(2);
            } else {
                config.setJdbcType(4);
            }
            config.setCharset(this.page3.charsetText.getText());
            config.setConvertUnicode(this.page3.unicodeCheck.getSelection());
            config.setAutoCommit(this.page3.commitModeCheck.getSelection());
            config.setOnlyDefaultSchema(false);
            if (this.page3.symfowareOptionCheck != null) {
                config.setNoLockMode(this.page3.symfowareOptionCheck.getSelection());
            } else {
                config.setNoLockMode(true);
            }
            if (this.page2.connectionModeCombox != null) {
                index = this.page2.connectionModeCombox.getSelectionIndex();
                switch (index) {
                    case 0: {
                        config.setConnectAsSYSDBA(false);
                        config.setConnectAsSYSOPER(false);
                        break;
                    }
                    case 1: {
                        config.setConnectAsSYSDBA(true);
                        config.setConnectAsSYSOPER(false);
                        break;
                    }
                    case 2: {
                        config.setConnectAsSYSDBA(false);
                        config.setConnectAsSYSOPER(true);
                    }
                }
            }
            if (this.page2.connectionModeCombox2 != null) {
                index = this.page2.connectionModeCombox2.getSelectionIndex();
                if (index == 0) {
                    config.setConnectAsInformationSchema(false);
                } else if (index == 1) {
                    config.setConnectAsInformationSchema(true);
                }
            }
            config.setDisplayedSchemas(this.page3.filterSchemas);
            config.setCheckFilterPattern(false);
            config.setFilterPattern(this.page3.filterPattern);
        }
        catch (Exception e) {
            DbPlugin.getDefault().showErrorDialog(e);
        }
        return config;
    }

    public IDBConfig getNewConfig() {
        return this.newConfig;
    }
}

