/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ext.oracle.internal;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.core.ResultSetUtil;
import zigen.plugin.db.core.SQLUtil;
import zigen.plugin.db.core.StatementUtil;
import zigen.plugin.db.core.Transaction;
import zigen.plugin.db.ui.internal.Table;

public class OracleIndexNameSearcher {
    public static String[] execute(IDBConfig config, Table table) throws Exception {
        Connection con = Transaction.getInstance(config).getConnection();
        return OracleIndexNameSearcher.execute(con, table);
    }

    public static String[] execute(Connection con, Table table) throws Exception {
        String[] stringArray;
        ResultSet rs = null;
        Statement st = null;
        try {
            ArrayList<String> list = new ArrayList<String>();
            st = con.createStatement();
            rs = st.executeQuery(OracleIndexNameSearcher.getSql(table));
            while (rs.next()) {
                list.add(rs.getString("INDEX_NAME"));
            }
            stringArray = list.toArray(new String[0]);
            Object var5_7 = null;
        }
        catch (Exception e) {
            try {
                DbPlugin.log(e);
                throw e;
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                ResultSetUtil.close(rs);
                StatementUtil.close(st);
                throw throwable;
            }
        }
        ResultSetUtil.close(rs);
        StatementUtil.close(st);
        return stringArray;
    }

    private static String getSql(Table table) {
        String owner = table.getSchemaName();
        String tableName = table.getName();
        StringBuffer sb = new StringBuffer();
        sb.append(" SELECT");
        sb.append("         INDEX_NAME");
        sb.append("     FROM");
        sb.append("         all_indexes");
        sb.append("     WHERE");
        sb.append("         table_owner = '" + SQLUtil.encodeQuotation(owner) + "'");
        sb.append("     AND table_name = '" + SQLUtil.encodeQuotation(tableName) + "'");
        return sb.toString();
    }
}

