package org.dbunitng.beans;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * クラスのメタ情報ファクトリ。
 * 
 * @author jyukutyo
 * 
 */
public class BeanMetaDataFactory {

	/** メタ情報のキャッシュ */
	private static final Map<Class<? extends Object>, BeanMetaData> cache =
		new ConcurrentHashMap<Class<? extends Object>, BeanMetaData>();

	/**
	 * コンストラクタ。
	 */
	protected BeanMetaDataFactory() {
		// empty
	}

	/**
	 * {@link BeanMetaData}を返す。
	 * 
	 * @param clazz
	 *            メタ情報を取得したいクラス
	 * @return BeanMetaData
	 */
	public static BeanMetaData getBeanMetaData(Class<? extends Object> clazz) {

		BeanMetaData beanMetaData = (BeanMetaData) cache.get(clazz);
		if (beanMetaData == null) {
			beanMetaData = new BeanMetaData(clazz);

			cache.put(clazz, beanMetaData);
		}
		return beanMetaData;

	}

}
