package daruma.xml.util;

import daruma.xml.util.DOMDocumentFactory;
import daruma.xml.URI;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

import javax.xml.parsers.ParserConfigurationException;

import org.xml.sax.SAXParseException;


public class ParseErrorDocumentBuilder
{
	private	SAXParseException	exception;

	public	ParseErrorDocumentBuilder( SAXParseException  exception )
	{
		this.exception = exception;
	}

	public	Document	newDocument()
				  throws ParserConfigurationException
	{
		Document	doc = DOMDocumentFactory.create();

		Element	top = doc.createElementNS( URI.MISP_ERROR ,
						   "ParseError" );
		top.setAttribute( "line" ,
				  Integer.toString
					  ( exception.getLineNumber() ) );
		top.setAttribute( "column" ,
				  Integer.toString
					  ( exception.getColumnNumber() ) );

		Element	mes = doc.createElementNS( URI.MISP_ERROR ,
						   "Message" );

		Text	errorMessageNode = doc.createTextNode
					   ( this.exception.getMessage() );

		mes.appendChild( errorMessageNode );

		top.appendChild( mes );

		doc.appendChild( top );

		return( doc );
	}
}
