package daruma.util;

import java.io.IOException;
import java.io.OutputStream;
import java.io.FilterOutputStream;

public class CountOutputStream extends FilterOutputStream
{
	private	long	byteCount = 0;

	public	CountOutputStream( OutputStream  out )
	{
		super( out );
	}

	public	void	write( int  b ) throws IOException
	{
		super.out.write( b );

		this.byteCount ++;
	}

	public	void	write( byte[]  b ) throws IOException
	{
		super.out.write( b );

		this.byteCount += b.length;
	}

	public	void	write( byte[]  b ,  int  off ,  int  len )
							throws IOException
	{
		super.out.write( b , off , len );

		this.byteCount += len;
	}


	/**
	 * returns number of wrote bytes
	 */
	public	long	getByteCount()
	{
		return( this.byteCount );
	}
}
