package daruma.storage_manager.type_definition;

import daruma.storage_manager.type_definition.TypedInstance;
import daruma.storage_manager.StorageManager;
import daruma.storage_manager.ElementInfo;

import daruma.geometry.TransformationContext;

import daruma.sql.SQLDataType;
import daruma.sql.TableColumnDefinition;
import daruma.sql.TableColumn;

import daruma.xml.SimpleXPath;
import org.w3c.dom.Element;
import org.w3c.dom.Document;

import daruma.util.Pair;
import java.util.List;


public abstract class TypeDefinition
{
	private	boolean	isXMLComplexType;
	private	boolean	isSQLMultiColumn;
	private	boolean	isSQLExternalTable;

	public	TypeDefinition( boolean  isXMLComplexType ,
				boolean  isSQLMultiColumn )
	{
		this.isXMLComplexType = isXMLComplexType;
		this.isSQLMultiColumn = isSQLMultiColumn;
	}

	public	boolean	isXMLComplexType()
	{
		return( this.isXMLComplexType );
	}

	public	boolean	isSQLMultiColumn()
	{
		return( this.isSQLMultiColumn );
	}


	public	void	setIsSQLExternalTable( boolean isSQLExternalTable )
	{
		this.isSQLExternalTable = isSQLExternalTable;
	}

	public	boolean	isSQLExternalTable()
	{
		return( this.isSQLExternalTable );
	}


	/**
	 * returns a SQL type such as char, blob
	 *
	 *  if this type is composite type, returns null
	 */
	public abstract SQLDataType	getSingleSQLDataType();


	/**
	 * returns an array of table column
	 *
	 *  if this type is simple type, returns null
	 */
	public	List<TableColumnDefinition>	getCompositeSQLDataType
						  ( StorageManager  storage ,
						    SimpleXPath  path,
						    ElementInfo elementInfo )
							throws TypeException
	{
		// XXX: should be abstract?
		return( null );
	}


	public abstract Pair<TypedInstance, Integer>
				createInstance( Element  element ,
						ElementName  topLevelElement ,
						SimpleXPath  path ,
						StorageManager  storage ,
						int  elementIndex )
							throws TypeException;

	public	abstract int	convertToXMLElement
					( Element  element ,
					  Document  doc ,
					  StorageManager  storage ,
					  TransformationContext  trans ,
					  List<TableColumn>  columns ,
					  int  index ,
					  long  id ) throws TypeException;

	public	boolean	shouldSkipColumns( List<TableColumn>  columns ,
					   int  columnIndex )
							throws TypeException
	{
		String v = columns.get( columnIndex ).getValue();

		return( v == null );
	}

	public	String	getSubTableName()
	{
		return( null );
	}
}
