package daruma.storage_manager;

import daruma.storage_manager.type_definition.ElementName;
import daruma.storage_manager.type_definition.TypedInstance;

import daruma.util.Pair;

import java.util.List;
import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;

public class BulkInsertBuffer
{
    private Map< ElementName, List<TypedInstance> > buffer;
    long count = 0;

    public BulkInsertBuffer()
    {
	this.buffer = new HashMap< ElementName, List<TypedInstance> >();
    }

    public void insertElement( ElementName elementName, TypedInstance obj )
    {
	if ( ! this.buffer.containsKey( elementName ) )
	{
	    this.buffer.put( elementName, new ArrayList<TypedInstance>() );

	}

	this.buffer.get( elementName ).add( obj );
	this.count ++;
    }

    public Map< ElementName, List<TypedInstance> > getBuffer()
    {
	return this.buffer;
    }

    public long size()
    {
	return this.count;
    }

    public void clear()
    {
	this.buffer.clear();
	this.count = 0;
    }
}
