package xmlUtil;

import daruma.xml.handler.XSAXDOMCreateHandler;
import daruma.wfs.SAXExceptionObserver;

import daruma.xml.util.XMLFormatConverter;

import org.xml.sax.XMLReader;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import javax.xml.transform.TransformerException;

import java.io.OutputStream;
import java.io.UnsupportedEncodingException;


public class EchoXSAXHandler extends XSAXDOMCreateHandler
			     implements SAXExceptionObserver
{
	private	SAXExceptionObserver	errorReceiver;
	private	String			encoding;

	public	EchoXSAXHandler( OutputStream  out ,
				 String  encoding ,
				 XMLReader  parser ,
				 boolean  isTopLevelHandler ,
				 SAXExceptionObserver  errorReceiver )
	{
		super( out , parser , isTopLevelHandler );
		super.setInhibitEndPrefixBeforeEndDocument( true );

		this.encoding = encoding;
		this.errorReceiver = errorReceiver;
	}

	@Override
	public  void  xEndDocument() throws SAXException
	{
		try
		{
			XMLFormatConverter.print
				( super.getDocumentElement() ,
				  super.getOutputStream() ,
				  false ,
				  this.encoding );
		}
		catch( UnsupportedEncodingException  e )
		{
			this.notifyError( new SAXParseException
					  ( e.getMessage() ,
					    super.getLocator() ) );
		}
		catch( TransformerException  e )
		{
			this.notifyError( new SAXParseException
					  ( e.getMessage() ,
					    super.getLocator() ) );
		}
	}


	public	void	notifyError( SAXParseException  e ) throws SAXException
	{
		this.errorReceiver.notifyError( e );

		throw e;
	}
}
