package mispClient.commands;

import mispClient.MispCommand;
import mispClient.MispCommandException;
import xmlUtil.XMLUtil;
import xmlUtil.SimpleXPathXSAXHandler;

import daruma.storage_manager.type_definition.ElementName;
import daruma.xml.UniversalName;
import daruma.xml.URI;
import daruma.xml.SimpleXPath;
import daruma.xml.handler.XSAXDefaultHandler;
import daruma.xml.util.XMLFormatConverter;
import daruma.util.CharacerCodeConstant;

import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;
import org.xml.sax.XMLReader;
import org.xml.sax.SAXException;

import javax.xml.parsers.ParserConfigurationException;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.io.IOException;
import java.util.List;
import java.util.ArrayList;



public class DescribeFeatureTypeMispCommand extends MispCommand
{
	private	static final String DESCRIBE_FEATURE_TYPE_ELEMENT_NAME
					    = "DescribeFeatureType";
	private	static final String TYPE_NAME_ELEMENT_NAME
					    = "TypeName";
	private	static final String DESCRIBE_FEATURE_TYPE_RESPONSE_ELEMENT_NAME
					    = "DescribeFeatureTypeResponse";

	private	static final String SCHEMA_ELEMENT_NAME
					    = "schema";


	private	final List<ElementName>	features;
	private	Document	resultDocument;
	private	OutputStream	out;
	private	String		encoding;

	public	DescribeFeatureTypeMispCommand( List<ElementName>  features ,
						OutputStream  out ,
						String  encoding )
	{
		this.features = new ArrayList<ElementName>( features );
		this.resultDocument = null;
		this.out = out;
		this.encoding = encoding;
	}


	@Override
	public	InputStream	getInputStream()
	{
		StringBuilder	buf = new StringBuilder();


		buf.append( "<" + MISP_PREFIX + ":"
			    + DESCRIBE_FEATURE_TYPE_ELEMENT_NAME
			    + " xmlns:" + MISP_PREFIX + "=\""
			    + URI.MISP + "\">\n" );

		for ( ElementName  f : this.features )
		{
			buf.append( "  <" + MISP_PREFIX + ":"
				    + TYPE_NAME_ELEMENT_NAME
				    + " xmlns=\"" + f.getNamespace() + "\">" );

			try
			{
				buf.append
				    ( new String
				      ( f.getLocalName().getBytes() ,
					CharacerCodeConstant.JAVA_UTF8 ) );
			}
			catch( UnsupportedEncodingException  e )
			{
				e.printStackTrace();
			}

			buf.append( "</" + MISP_PREFIX + ":"
				    + TYPE_NAME_ELEMENT_NAME + ">\n");
		}


		buf.append( "</" + MISP_PREFIX + ":"
			    + DESCRIBE_FEATURE_TYPE_ELEMENT_NAME + ">\n" );

		return( new ByteArrayInputStream
			( buf.toString().getBytes() ) );
	}


	@Override
	public	void	processResponse( InputStream  in )
					   throws MispCommandException
	{
		SimpleXPath	path = new SimpleXPath();

		path.add( new UniversalName
			  ( URI.MISP ,
			    DESCRIBE_FEATURE_TYPE_RESPONSE_ELEMENT_NAME ) );
		path.add( new UniversalName
			  ( URI.XML_SCHEMA ,
			    SCHEMA_ELEMENT_NAME ) );

		try
		{
			XMLReader	parser = XMLUtil.createSAXParser();

			XSAXDefaultHandler	handler;
			handler = new SimpleXPathXSAXHandler
					( path , this.out , this.encoding ,
					  parser , false );

			XMLUtil.handleXMLInputStream( handler , parser , in );
		}
		catch( SAXException  e )
		{
			throw new MispCommandException( e.getMessage() , e );
		}
		catch( IOException  e )
		{
			throw new MispCommandException( e.getMessage() , e );
		}
		catch( ParserConfigurationException  e )
		{
			throw new MispCommandException( e.getMessage() , e );
		}
	}


	/*
	@Override
	public	void	processResponse( InputStream  in )
					   throws MispCommandException
	{
		try
		{
			this.resultDocument
				= XMLFormatConverter.streamToDOMDocument( in );
		}
		catch( TransformerException  e )
		{
			throw new MispCommandException( e );
		}
	}


	public	Document	getResultDocument()
	{
		return( this.resultDocument );
	}
	*/
}
