package mispClient.commands;

import mispClient.MispCommand;
import mispClient.MispCommandException;
import util.StreamPipe;

import daruma.storage_manager.type_definition.ElementName;
import daruma.xml.URI;
import daruma.util.CharacerCodeConstant;

import org.w3c.dom.Element;


import java.io.InputStream;
import java.io.OutputStream;
import java.io.IOException;
import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;


public class DarumaDumpMispCommand extends MispCommand
{
	private	static final String	GET_FEATURE_ELEMENT_NAME
						    = "GetFeature";
	private	static final String	QUERY_ELEMENT_NAME
						    = "Query";
	private	static final String	FILTER_ELEMENT_NAME
						    = "Filter";
	private	static final String	TRUE_ELEMENT_NAME
						    = "True";
	private	static final String	MISP_PREFIX = "misp";


	private	final ElementName	featureName;
	private	OutputStream	out;

	public	DarumaDumpMispCommand( ElementName  featureName ,
				       OutputStream  out )
	{
		this.featureName = featureName;
		this.out = out;
	}


	@Override
	public	InputStream	getInputStream()
					   throws MispCommandException
	{
		StringBuilder	buf = new StringBuilder();

		buf.append( "<" + MISP_PREFIX + ":"
			    + GET_FEATURE_ELEMENT_NAME
			    + " xmlns:" + MISP_PREFIX + "=\""
			    + URI.MISP + "\""
			    + " xmlns=\"" + featureName.getNamespace()
			    + "\">\n" );

		String	localName = featureName.getLocalName();

		buf.append( "  <" + MISP_PREFIX + ":" + QUERY_ELEMENT_NAME
			    + " typeName=\"" + localName + "\">\n" );

		buf.append( "    <" + MISP_PREFIX + ":" + FILTER_ELEMENT_NAME
			    + ">\n" );

		buf.append( "      <" + MISP_PREFIX + ":" + TRUE_ELEMENT_NAME
			    + "/>\n" );

		buf.append( "    </" + MISP_PREFIX + ":" + FILTER_ELEMENT_NAME
			    + ">\n" );

		buf.append( "  </" + MISP_PREFIX + ":" + QUERY_ELEMENT_NAME
			    + ">\n" );

		buf.append( "</" + MISP_PREFIX + ":"
			    + GET_FEATURE_ELEMENT_NAME + ">\n" );

		try
		{
			return( new ByteArrayInputStream
				( buf.toString().getBytes
				  ( CharacerCodeConstant.JAVA_UTF8 ) ) );
		}
		catch( UnsupportedEncodingException  e )
		{
			throw new MispCommandException( e );
		}
		catch( IOException  e )
		{
			throw new MispCommandException( e );
		}
	}


	@Override
	public	void	processResponse( InputStream  in )
					   throws MispCommandException
	{
		try
		{
			StreamPipe.connect( in , this.out );
		}
		catch( IOException  e )
		{
			throw new MispCommandException( e );
		}
	}
}
