/*
 * Decompiled with CFR 0.152.
 */
package xmlUtil;

import daruma.util.CloseIgnoreInputStream;
import daruma.xml.QName;
import daruma.xml.UniversalName;
import daruma.xml.handler.XSAXDefaultHandler;
import daruma.xml.util.NodeUtil;
import daruma.xml.util.XMLFormatConverter;
import daruma.xml.util.XMLParseErrorException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLUtil {
    public static List<UniversalName> getUniversalNamesFromXPathQName(String xPathString, InputStream in) throws XMLParseErrorException, XPathExpressionException {
        NodeList elementList;
        Document doc;
        try {
            doc = XMLFormatConverter.streamToDOMDocument((InputStream)in);
        }
        catch (TransformerException e) {
            throw new XMLParseErrorException((Throwable)e);
        }
        XPath xPath = XPathFactory.newInstance().newXPath();
        try {
            elementList = (NodeList)xPath.evaluate(xPathString, doc, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
            throw e;
        }
        ArrayList<UniversalName> names = new ArrayList<UniversalName>();
        for (int i = 0; i < elementList.getLength(); ++i) {
            Element e = (Element)elementList.item(i);
            QName qName = new QName(e.getTextContent());
            if (!qName.isValid()) {
                throw new XMLParseErrorException("invalid QName [" + qName + "]");
            }
            String namespaceURI = NodeUtil.lookupNamespaceURI((Node)e, (String)qName.getPrefix());
            names.add(new UniversalName(namespaceURI, qName.getLocalName()));
        }
        return names;
    }

    public static XMLReader createSAXParser() throws ParserConfigurationException, SAXException {
        XMLReader parser;
        SAXParserFactory f = SAXParserFactory.newInstance();
        f.setNamespaceAware(true);
        try {
            parser = f.newSAXParser().getXMLReader();
        }
        catch (ParserConfigurationException e) {
            throw e;
        }
        catch (SAXException e) {
            throw e;
        }
        return parser;
    }

    public static void handleXMLInputStream(XSAXDefaultHandler handler, XMLReader parser, InputStream in) throws SAXException, IOException {
        parser.setContentHandler((ContentHandler)handler);
        parser.setErrorHandler((ErrorHandler)handler);
        parser.parse(new InputSource((InputStream)new CloseIgnoreInputStream(in)));
    }
}

