/*
 * Decompiled with CFR 0.152.
 */
package daruma.xml.util;

import daruma.xml.QName;
import daruma.xml.SimpleXPath;
import daruma.xml.UniversalName;
import daruma.xml.util.PrefixMap;
import daruma.xml.util.XMLParseErrorException;

public class TextUtil {
    private TextUtil() {
    }

    public static SimpleXPath convertQNamePathToSimpleXPath(String text, PrefixMap prefixMap) throws XMLParseErrorException {
        String[] propQNamePathList = text.trim().split("/");
        if (propQNamePathList.length == 0) {
            throw new XMLParseErrorException("empty property path \"" + text + "\"");
        }
        SimpleXPath ret = new SimpleXPath();
        for (String propQNameString : propQNamePathList) {
            QName q = new QName(propQNameString);
            if (!q.isValid()) {
                throw new XMLParseErrorException("[" + propQNameString + "]" + " is not a valid QName");
            }
            String namespaceURI = prefixMap.get(q.getPrefix());
            ret.add(new UniversalName(namespaceURI, q.getLocalName()));
        }
        return ret;
    }
}

