/*
 * Decompiled with CFR 0.152.
 */
package daruma.global_switch;

import daruma.util.FatalException;
import daruma.util.PropertyReader;

public class ImplementationSwitches {
    private static final String ENABLE_GEOMETRY_CONVERSION_PROPERTY = "daruma.geometry.enable_conversion";
    private static final boolean ENABLE_GEOMETRY_CONVERSION_DEFAULT = true;
    private boolean enableGeometryConversion = PropertyReader.getProperty("daruma.geometry.enable_conversion", true);
    private static final String ALLOW_CONVERSION_TO_LOWER_DIMENSION_PROPERTY = "daruma.geometry.allow_conversion_to_lower_dimension";
    private static final String ALLOW_CONVERSION_TO_UPPER_DIMENSION_PROPERTY = "daruma.geometry.allow_conversion_to_upper_dimension";
    private static final boolean ALLOW_CONVERSION_TO_LOWER_DIMENSION_DEFAULT = true;
    private static final boolean ALLOW_CONVERSION_TO_UPPER_DIMENSION_DEFAULT = true;
    private boolean allowConversionToLowerDimension = PropertyReader.getProperty("daruma.geometry.allow_conversion_to_lower_dimension", true);
    private boolean allowConversionToUpperDimension = PropertyReader.getProperty("daruma.geometry.allow_conversion_to_upper_dimension", true);
    private static final String CREATE_GEOMETRY_INDEX_PROPERTY = "daruma.geometry.create_geometry_index";
    private static final boolean CREATE_GEOMETRY_INDEX_DEFAULT = false;
    private boolean createGeometryIndex = PropertyReader.getProperty("daruma.geometry.create_geometry_index", false);
    private String BACKEND_DB_TYPE_PROPERTY = "daruma.db.backend";
    private static final String BACKEND_DB_TYPE_DEFAULT = "MySQL";
    private BackendDBType backendDBType;
    private String MYSQL_HOST_PROPERTY = "daruma.mysql.host";
    private String MYSQL_PORT_PROPERTY = "daruma.mysql.port";
    private static final String MYSQL_HOST_DEFAULT = "localhost";
    private static final int MYSQL_PORT_DEFAULT = 3306;
    private static String mysqlHost;
    private static int mysqlPort;
    private static ImplementationSwitches obj;

    public ImplementationSwitches() throws FatalException {
        String backendDBTypeString = PropertyReader.getProperty(this.BACKEND_DB_TYPE_PROPERTY, BACKEND_DB_TYPE_DEFAULT);
        if (backendDBTypeString.equals("PostGIS")) {
            this.backendDBType = BackendDBType.PostGIS;
        } else if (backendDBTypeString.equals(BACKEND_DB_TYPE_DEFAULT)) {
            this.backendDBType = BackendDBType.MySQL;
        } else {
            throw new FatalException("invalid property value of [" + this.BACKEND_DB_TYPE_PROPERTY + "]," + " value = [" + (Object)((Object)this.backendDBType) + "]," + " expected was [PostGIS] or [MySQL].");
        }
        mysqlHost = PropertyReader.getProperty(this.MYSQL_HOST_PROPERTY, MYSQL_HOST_DEFAULT);
        mysqlPort = PropertyReader.getProperty(this.MYSQL_PORT_PROPERTY, 3306);
    }

    public boolean getEnableGeometryConversion() {
        return this.enableGeometryConversion;
    }

    public boolean getAllowConversionToLowerDimension() {
        return this.allowConversionToLowerDimension;
    }

    public boolean getAllowConversionToUpperDimension() {
        return this.allowConversionToUpperDimension;
    }

    public boolean getCreateGeometryIndex() {
        return this.createGeometryIndex;
    }

    public BackendDBType getBackendDBType() {
        return this.backendDBType;
    }

    public boolean isPostGISBackend() {
        return this.backendDBType == BackendDBType.PostGIS;
    }

    public boolean isMySQLBackend() {
        return this.backendDBType == BackendDBType.MySQL;
    }

    public String getMySQLHost() {
        return mysqlHost;
    }

    public int getMySQLPort() {
        return mysqlPort;
    }

    public static void createInstance() throws FatalException {
        if (obj == null) {
            obj = new ImplementationSwitches();
        }
    }

    public static ImplementationSwitches instance() {
        return obj;
    }

    static {
        obj = null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BackendDBType {
        PostGIS,
        MySQL;

    }
}

