/*
 * Decompiled with CFR 0.152.
 */
package daruma.geometry;

import daruma.geometry.DrmLinearRing;
import daruma.geometry.DrmPoint;
import daruma.geometry.DrmPolygon;
import daruma.geometry.GeometryException;

public class DrmBox
extends DrmPolygon {
    private int dimension;
    private double minX;
    private double minY;
    private double maxX;
    private double maxY;

    public DrmBox(DrmPoint minPoint, DrmPoint maxPoint) throws GeometryException {
        if (minPoint.getDimension() != maxPoint.getDimension()) {
            throw new GeometryException("Point dimension mismatch in Box");
        }
        this.dimension = minPoint.getDimension();
        this.minX = minPoint.getX();
        this.minY = minPoint.getY();
        this.maxX = maxPoint.getX();
        this.maxY = maxPoint.getY();
        DrmLinearRing outerBoundary = new DrmLinearRing();
        outerBoundary.add(new DrmPoint(this.minX, this.minY));
        outerBoundary.add(new DrmPoint(this.maxX, this.minY));
        outerBoundary.add(new DrmPoint(this.maxX, this.maxY));
        outerBoundary.add(new DrmPoint(this.minX, this.maxY));
        outerBoundary.add(new DrmPoint(this.minX, this.minY));
        super.setOuterBoundary(outerBoundary);
    }

    public int getDimension() {
        return this.dimension;
    }

    public double getMinX() {
        return this.minX;
    }

    public double getMinY() {
        return this.minY;
    }

    public double getMaxX() {
        return this.maxX;
    }

    public double getMaxY() {
        return this.maxY;
    }
}

