#include <iostream>
#include <cstdlib>

static bool xmltest( const char * path );

int main( int argc, char * argv[] )
{
    const char * path = static_cast<const char *>(0);

    if ( argc == 2 )
    {
        path = argv[1];
    }
    else
    {
        std::cerr << "Usage: " << argv[0] << " FILE.xml" << std::endl;

        return EXIT_FAILURE;
    }

    if ( ! xmltest( path ) )
    {
        return EXIT_FAILURE;
    }

    return EXIT_SUCCESS;
}


#include <iostream>
#include <string>

#include "local_encoded_string.h"

#include <xercesc/parsers/XercesDOMParser.hpp>
#include <xercesc/util/PlatformUtils.hpp>
#include <xercesc/framework/MemBufInputSource.hpp>
#include <xercesc/framework/LocalFileInputSource.hpp>

#include <xercesc/dom/DOM.hpp>
#include <xercesc/dom/DOMNode.hpp>

#include "path_converter.h"


using namespace xercesc;

static void print_node( const DOMNode * node );

static
bool xmltest( const char * path )
{
    //
    // initialize
    //
    try
    {
        XMLPlatformUtils::Initialize();
    }
    catch( const XMLException & e )
    {
        std::cerr << Local_Encoded_String( e.getMessage() ) << std::endl;

        return false;
    }


    //
    // Make Parser
    //
    XercesDOMParser * parser = new XercesDOMParser;
//  parser -> setValidationScheme( XercesDOMParser::Val_Always );
    parser -> setDoNamespaces( true );
    parser -> setIncludeIgnorableWhitespace( false );
    parser -> setDoSchema( false );
//  parser -> setCreateEntityReferenceNodes( false );

    try
    {
        LocalFileInputSource buf( XML_Parser_Encoded_String( path ) );

        parser -> parse( path );

        int n_errors = parser -> getErrorCount();

        if ( n_errors != 0 )
        {
            std::cerr << "parse failed" << std::endl;
            return false;
        }

        DOMDocument * doc = parser -> getDocument();
        DOMElement * top_level_element = doc -> getDocumentElement();

        print_node( top_level_element );
    }
    catch( const XMLException &  e )
    {
        std::cerr << Local_Encoded_String( e.getMessage() ) << std::endl;

        return false;
    }

    //
    // Delete Parser
    //
    delete parser;

    //
    // finalize
    //
    XMLPlatformUtils::Terminate();

    return true;

}


void print_node( const DOMNode * node )
{
    if ( node == static_cast<const DOMNode *>(0) )
    {
        return;
    }

    if ( node -> getNodeType() == node -> ELEMENT_NODE )
    {
        Local_Encoded_String node_name( node -> getNodeName() );

#if 0
        std::cerr << "element name = [" << node_name << "]" << std::endl;
#endif

        const DOMNodeList * child_nodes = node -> getChildNodes();
        for ( size_t i = 0 ; i < child_nodes->getLength() ; ++ i )
        {
            print_node( child_nodes -> item( i ) );
        }
    }
    else if ( node -> getNodeType() == node -> TEXT_NODE )
    {
        Local_Encoded_String node_name( node -> getNodeName() );
        const std::string value = Local_Encoded_String( node -> getTextContent() );

#if 0
        std::cerr << "text node [" << node_name << "] = "
                  << "[" << value << "]" << std::endl;
#endif

        bool whitespace_only = true;
        for ( size_t i = 0 ; i < value.length() ; ++ i )
        {
            if ( value[i] != ' '
                 && value[i] != '\t'
                 && value[i] != '\r'
                 && value[i] != '\n' )
            {
                whitespace_only = false;
                break;
            }
        }

        if ( whitespace_only )
        {
            return;
        }

        const DOMNode * p = node -> getParentNode();

        std::string path;

        while( p != static_cast<const DOMNode *>(0)
               && p -> getNodeType() != node -> DOCUMENT_NODE )
        {
            std::string node_name = Local_Encoded_String( p -> getNodeName() );

            Local_Encoded_String namespace_uri( p -> getNamespaceURI() );

            std::string namespace_uri_str;
            std::string namespace_uri_str_with_braces;

            if ( ! namespace_uri.is_null() )
            {
                namespace_uri_str = Path_Converter::escape_slash( namespace_uri );
                namespace_uri_str_with_braces = std::string( "{" ) + namespace_uri_str + "}";
            }

            path = std::string( "/" )
                   + namespace_uri_str_with_braces + node_name + path;

            p = p -> getParentNode();
        }

        std::cerr << "@@@" << "path = [" << path << "] = [" << value << "]"
                  << std::endl;
    }
    else
    {
        std::cerr << "!!!" << std::endl;
    }
}
