#ifndef	   TEST_ENVIRONMENT_H_INCLUDED
#define	   TEST_ENVIRONMENT_H_INCLUDED

// Author:		H. Shimora
// Created:		Jul 16 2003
// Version:		0.00

///-----------------------------------------------
/// Change Log:
///-----------------------------------------------
// version 0.00  Jul 16 2003    base version.
//
//

#include  <iostream>
#include  <string>
#include  <cstdlib>
#include  <cctype>
#include  <cmath>
#if ! defined( NO_INTTYPES_H )
# include  <inttypes.h>
#endif
#include  "ref_count_ptr.h"

class  Test_Environment
{
private:
	unsigned long	succeeded_count;
	unsigned long	failed_count;

private:
	void	test_passed()
	{
		this -> succeeded_count ++;
#if 0
		std::cerr << ".";
#endif
	}

	void	test_not_passed()
	{
		this -> failed_count ++;
		std::cerr << "!" << std::endl;
	}

public:
		 Test_Environment()
			 : succeeded_count( 0 ) , failed_count( 0 ) {}

	virtual	~Test_Environment()
	{
#if 0
		std::cerr << std::endl;
#endif

		if ( this -> failed_count == 0 )
		{
			std::cerr << "All tests succeeded !!" << std::endl;
		}
		else
		{
			std::cerr << "Tests finished with Failure !!"
				  << std::endl;

			std::cerr << "Failed " << this -> failed_count << ", "
				  << "Succeeded " << this -> succeeded_count
				  << std::endl;
		}
	}

	int	exit_status() const
	{
		return( this -> failed_count == 0 ? 0 : 1 );
	}

	void	OK()
	{
		this -> test_passed();
	}

	bool   Assert( bool  condition ,  const std::string &  message = "" )
	{
		if ( condition )
		{
			this -> test_passed();
		}
		else
		{
			this -> test_not_passed();

			std::cerr << "assert failed";
			if ( ! message.empty() )
			{
				std::cerr << ": " << message;
			}
			std::cerr << std::endl;
		}

		return( condition );
	}

	bool   Assert_Critical( bool  condition ,
				const std::string &  message = "" )
	{
		if ( condition )
		{
			this -> test_passed();
		}
		else
		{
			this -> test_not_passed();

			std::cerr << "assert failed (critical)";
			if ( ! message.empty() )
			{
				std::cerr << ": " << message;
			}
			std::cerr << std::endl;

			std::exit( 1 );
		}

		return( condition );
	}


	template<typename T>
	bool   Assert_Equals( const T &  a ,  const T &  b )
	{
		if ( a == b )
		{
			this -> test_passed();
			return( true );
		}
		else
		{
			this -> test_not_passed();

#if 0
			std::cerr << "[" << b << "] should be [" << a << "]"
				  << std::endl;
#endif
			return( false );
		}
	}

	template<typename T>
	bool   Assert_Equals_without_Print( const T &  a ,  const T &  b )
	{
		if ( a == b )
		{
			this -> test_passed();
			return( true );
		}
		else
		{
			this -> test_not_passed();
			return( false );
		}
	}

	template<typename T>
	bool   Assert_Equals_Critical( const T &  a ,  const T &  b ,
				       const std::string &  message = "" )
	{
		if ( a == b )
		{
			this -> test_passed();
			return( true );
		}
		else
		{
			this -> test_not_passed();

			std::cerr << "[" << b << "] should be [" << a << "]"
				  << "(critical)" << std::endl;

			if ( ! message.empty() )
			{
				std::cerr << ": " << message;
			}
			std::cerr << std::endl;

			std::exit( 1 );
		}

		/*NOTREACHED*/
		return( false );
	}

	template<typename T>
	bool   Assert_Equals_Critical_without_Print
				     ( const T &  a ,  const T &  b ,
				       const std::string &  message = "" )
	{
		if ( a == b )
		{
			this -> test_passed();
			return( true );
		}
		else
		{
			this -> test_not_passed();
			std::exit( 1 );
		}

		/*NOTREACHED*/
		return( false );
	}


	bool   Assert_Equals( const std::string &  a ,
			      const std::string &  b )
	{
		if ( a == b )
		{
			this -> test_passed();
			return( true );
		}
		else
		{
			this -> test_not_passed();

			std::cerr << "[" << b << "] should be [" << a << "]"
				  << std::endl;

			return( false );
		}
	}

	bool   Assert_Equals( const std::string &  a ,  const char *  b )
	{
		return( Assert_Equals( a , std::string(b) ) );
	}

	bool   Assert_Equals( const char *  a ,  const std::string &  b )
	{
		return( Assert_Equals( std::string(a) , b ) );
	}

	bool   Assert_Equals( char  a ,  char  b )
	{
		if ( a == b )
		{
			this -> test_passed();
			return( true );
		}
		else
		{
			std::cerr << "character ";
			if ( isprint( static_cast<unsigned char>( b ) ) )
			{
				std::cerr << "[" << b << "]";
			}
			std::cerr << "(" << static_cast<int>( b ) << ") ";

			std::cerr << "should be ";

			if ( isprint( static_cast<unsigned char>( a ) ) )
			{
				std::cerr << "[" << a << "]";
			}
			std::cerr << "(" << static_cast<int>( a ) << ") "
				  << std::endl;

			return( false );
		}
	}


	bool   Assert_Equals( unsigned char  a ,  unsigned char  b )
	{
		if ( a == b )
		{
			this -> test_passed();
			return( true );
		}
		else
		{
			std::cerr << "character ";
			if ( isprint( b ) )
			{
				std::cerr << "[" << b << "]";
			}
			std::cerr << "(" << static_cast<int>( b ) << ") ";

			std::cerr << "should be ";

			if ( isprint( a ) )
			{
				std::cerr << "[" << a << "]";
			}
			std::cerr << "(" << static_cast<int>( a ) << ") "
				  << std::endl;

			return( false );
		}
	}

	bool   Assert_Equals( signed char  a ,  signed char  b )
	{
		if ( a == b )
		{
			this -> test_passed();
			return( true );
		}
		else
		{
			std::cerr << "character ";
			if ( isprint( static_cast<unsigned char>( b ) ) )
			{
				std::cerr << "[" << b << "]";
			}
			std::cerr << "(" << static_cast<int>( b ) << ") ";

			std::cerr << "should be ";

			if ( isprint( static_cast<unsigned char>( a ) ) )
			{
				std::cerr << "[" << a << "]";
			}
			std::cerr << "(" << static_cast<int>( a ) << ") "
				  << std::endl;

			return( false );
		}
	}

	bool   Assert_Equals( int  a ,  int  b )
	{
		if ( a == b )
		{
			this -> test_passed();
			return( true );
		}
		else
		{
			this -> test_not_passed();

			std::cerr << "[" << b << "] should be [" << a << "]"
				  << std::endl;

			return( false );
		}
	}

	bool   Assert_Equals( size_t  a ,  size_t  b )
	{
		if ( a == b )
		{
			this -> test_passed();
			return( true );
		}
		else
		{
			this -> test_not_passed();

			std::cerr << "[" << b << "] should be [" << a << "]"
				  << std::endl;

			return( false );
		}
	}

#if ! defined( NO_INTTYPES_H )
	bool   Assert_Equals( int64_t  a ,  int64_t  b )
	{
		if ( a == b )
		{
			this -> test_passed();
			return( true );
		}
		else
		{
			this -> test_not_passed();

			std::cerr << "[" << b << "] should be [" << a << "]"
				  << std::endl;

			return( false );
		}
	}
#endif


	bool   Assert_Nearly_Equals( double  a ,  double  b ,
				     double  eps = 1.0e-6 )
	{
		double	diff = std::fabs( a - b );

		if ( std::fabs( a - b ) < eps )
		{
			this -> test_passed();
			return( true );
		}
		else
		{
			this -> test_not_passed();

			std::cerr << "[" << b << "] "
				  << "should be nearly [" << a << "], "
				  << "(diff = " << diff << ")"
				  << std::endl;

			return( false );
		}
	}

	template<typename T>
	bool   Assert_Not_Equals( const T &  a ,  const T &  b )
	{
		if ( a != b )
		{
			this -> test_passed();
			return( true );
		}
		else
		{
			this -> test_not_passed();

#if 0
			std::cerr << "[" << b << "] "
				  << "should not be [" << a << "]"
				  << std::endl;
#endif
			return( false );
		}
	}

	template<typename T>
	bool   Assert_Not_Equals_without_Print( const T &  a ,  const T &  b )
	{
		if ( a != b )
		{
			this -> test_passed();
			return( true );
		}
		else
		{
			this -> test_not_passed();
			return( false );
		}
	}

	bool   Assert_Not_Equals( const std::string &  a ,  const char *  b )
	{
		return( Assert_Not_Equals( a , std::string(b) ) );
	}

	bool   Assert_Not_Equals( const char *  a ,  const std::string &  b )
	{
		return( Assert_Not_Equals( std::string(a) , b ) );
	}

	template<typename T>
	bool   Assert_Null( const T &  a )
	{
		return( Assert( a == 0 , "should be null" ) );
	}

	template<typename T>
	bool   Assert_Not_Null( const T &  a )
	{
		return( Assert( a != 0 , "should not be null" ) );
	}

	template<typename T>
	bool   Assert_Null( const ref_count_ptr<T> &  a )
	{
		return( Assert( a.null() , "should be null" ) );
	}

	template<typename T>
	bool   Assert_Not_Null( const ref_count_ptr<T> &  a )
	{
		return( Assert( ! a.null() , "should not be null" ) );
	}
};

#if 1
#include  <stdexcept>
#include  <iostream>
#include  <cstdio>

#define	ASSERT(expression) \
do{ (expression) ? static_cast<void>(0) : \
	(static_cast<void>( std::cerr << __FILE__ << ":" << __LINE__ \
   << ": failed assertion(" << #expression << ")" << std::endl)); \
  } while(false)
#endif


#endif	/* TEST_ENVIRONMENT_H_INCLUDED */
