#include  "string_extension.h"
#include  "compat_stringstream.h"
#include  <cctype>
#include  <cstdio>
#include  <cstdlib>
#include  <cerrno>
#include  <cfloat>
#include  <climits>


namespace String_Extension
{


void    split_by_char_set( std::vector<std::string> *  result ,
			   const std::string &  str ,
			   const std::string &  char_set ,
			   bool  do_cutoff_edge )
{
	std::string	buf( str );

	if ( do_cutoff_edge )
	{
		cutoff_edge( &buf , char_set );
	}

	result -> clear();

	std::string::size_type	indx = 0;

	for(;;)
	{
		std::string::size_type	next_indx
					= buf.find_first_of( char_set , indx );

		if ( next_indx == std::string::npos )
		{
			if ( indx != 0 || buf.length() != 0 )
			{
				result -> push_back
					  ( std::string( buf , indx ) );
			}

			break;
		}
		else if ( next_indx == indx )
		{
			if ( indx == 0 )
			{
				result -> push_back( "" );
			}

			indx ++;
		}
		else
		{
			result -> push_back( std::string
					     ( buf ,
					       indx , next_indx - indx ) );
			indx = next_indx;
		}
	}
}


bool   separate_to_2_parts( std::string *  first ,
			    std::string *  second ,
			    const std::string &  str ,
			    char  separator ,
			    bool  do_cutoff_edge )
{
	std::string	buf( str );

	if ( do_cutoff_edge )
	{
		cutoff_edge( &buf , std::string( 1 , separator ) );
	}


	std::string::size_type
	    indx = buf.find_first_of( separator );

	if ( indx == std::string::npos )
	{
		*first  = "";
		*second = "";

		return( false );
	}

	*first  = buf.substr( 0 , indx );
	*second = buf.substr( indx + 1 );

	return( true );
}


std::string  join( const std::string &  separator ,
		   const std::vector<std::string> &  values )
{
	std::string	ret;

	for ( size_t  i = 0  ;  i < values.size()  ;  i ++ )
	{
		if ( i != 0 )
		{
			ret += separator;
		}

		ret += values[i];
	}

	return( ret );
}


bool   string_to_integer( int *  result ,  const std::string &  str )
{
	// XXX: range check
	long	long_value = 0;

	if ( string_to_long( &long_value ,  str ) )
	{
		*result = static_cast<long>( long_value );

		return( true );
	}
	else
	{
		return( false );
	}
}

bool   string_to_long( long *  result ,  const std::string &  str )
{
	// XXX: range check

	char *	end_char;
	*result = std::strtol( str.c_str() , &end_char , 10 );

	if ( *end_char != '\0' )
	{
		return( false );
	}

	if ( str.empty() )
	{
		return( false );
	}

	if ( *result == LONG_MAX )
	{
		return( false );
	}

	return( true );
}

bool	string_to_unsigned_long( unsigned long * result ,
				 const std::string &  str )
{
	long long_value;
	char *	end_char;
	long_value = std::strtol( str.c_str() , &end_char , 10 );

	if ( *end_char != '\0' )
	{
		return( false );
	}

	if ( str.empty() )
	{
		return( false );
	}

	if ( long_value == LONG_MAX
	     || long_value < 0 )
	{
		return( false );
	}

	*result = long_value;

	return( true );
}

bool	string_to_size_t( size_t * result ,
			  const std::string &  str )
{
	unsigned long long_value;
	if ( String_Extension::string_to_unsigned_long( &long_value , str ) )
	{
		*result = long_value;
		return( true );
	}
	else
	{
		return( false );
	}
}

#if ! defined( NO_INTTYPES_H )
bool   string_to_int64_t( int64_t *  result ,  const std::string &  str )
{
	compat_istringstream	buf( str );

	buf >> (*result);

	return( buf && buf.str().empty() );
}
#endif

bool   string_to_double( double *  result ,  const std::string &  str )
{
	char *	end_char;
	*result = std::strtod( str.c_str() , &end_char );

	if ( *end_char != '\0' )
	{
		return( false );
	}

	return( true );
}

bool   string_to_bool_literal_true_false( bool *  result ,
					  const std::string &  str )
{
	if ( str == "true" )
	{
		*result = true;

		return( true );
	}
	else if ( str == "false" )
	{
		*result = false;

		return( true );
	}

	return( false );
}


void   double_to_string( std::string *  result ,  double  value )
{
	compat_ostringstream	buf;

	buf << value;

	*result = buf.str();
}

void   double_to_string( std::string *  result ,  double  value ,
			 int  precision )
{
	compat_ostringstream	buf;
	buf.precision( (precision != 0 ? precision : DBL_DIG) );

	buf << value;

	*result = buf.str();
}

std::string  double_to_string( double  value )
{
	compat_ostringstream	buf;

	buf << value;

	return( buf.str() );
}

std::string  double_to_string( double  value ,  int  precision )
{
	compat_ostringstream	buf;
	buf.precision( (precision != 0 ? precision : DBL_DIG) );

	buf << value;

	return( buf.str() );
}

void   int_to_string( std::string *  result ,  int  value )
{
	compat_ostringstream	buf;

	buf << value;

	*result = buf.str();
}

std::string  int_to_string( int  value )
{
	compat_ostringstream	buf;

	buf << value;

	return( buf.str() );
}

void   long_to_string( std::string *  result ,  long  value )
{
	compat_ostringstream	buf;

	buf << value;

	*result = buf.str();
}

std::string  long_to_string( long  value )
{
	compat_ostringstream	buf;

	buf << value;

	return( buf.str() );
}

void   size_t_to_string( std::string *  result ,  size_t  value )
{
	compat_ostringstream	buf;

	buf << value;

	*result = buf.str();
}

std::string  size_t_to_string( size_t  value )
{
	compat_ostringstream	buf;

	buf << value;

	return( buf.str() );
}

#if ! defined( NO_INTTYPES_H )
void   int64_t_to_string( std::string *  result ,  int64_t  value )
{
	compat_ostringstream	buf;

	buf << value;

	*result = buf.str();
}

std::string  int64_t_to_string( int64_t  value )
{
	compat_ostringstream	buf;

	buf << value;

	return( buf.str() );
}
#endif

std::string  chomp( const std::string &  str )
{
	std::string	chomped_string = str;

	chomp( &chomped_string );

	return( chomped_string );
}

void   chomp( std::string *  str )
{
	if ( ! str -> empty()
	  && *(str -> rbegin()) == '\n' )
	{
		str -> erase( str -> end() - 1 );
	}

	if ( ! str -> empty()
	  && *(str -> rbegin()) == '\r' )
	{
		str -> erase( str -> end() - 1 );
	}
}

void   chomp( std::string *  str,  char  ch )
{
	if ( ! str -> empty()
	  && *(str -> rbegin()) == ch )
	{
		str -> erase( str -> end() - 1 );
	}
}

std::string	chomp_an_extension( const std::string &  from )
{
	std::string	result;

	chomp_an_extension( &result , from );

	return( result );
}

void	chomp_an_extension( std::string *  str ,
			    const std::string &  from )
{
	size_t	n = from.rfind( '.' );

	if ( n == std::string::npos )
	{
		*str = from;
	}

	str -> assign( from , 0 , n );
}

std::string  cutoff_edge( const std::string &  str ,
			  const std::string &  char_set )
{
	std::string	cutoff_string = str;

	cutoff_edge( &cutoff_string , char_set );

	return( cutoff_string );
}

void   cutoff_edge( std::string *  str ,
		    const std::string &  char_set )
{
	std::string::size_type	start_indx
				= str -> find_first_not_of( char_set );

	std::string::size_type	end_indx
				= str -> find_last_not_of( char_set );

	if ( start_indx == std::string::npos )
	{
		*str = "";
	}
	else
	{
		*str = str -> substr( start_indx , end_indx - start_indx + 1 );
	}
}


std::string  cutoff_edge_spaces( const std::string &  str )
{
	std::string	cutoff_string( str );

	cutoff_edge_spaces( &cutoff_string );

	return( cutoff_string );
}

void   cutoff_edge_spaces( std::string *  str )
{
	if ( str -> empty() )
	{
		return;
	}


	size_t	start;
	size_t	end;

	for ( start = 0  ;  start < str -> length()  ;  start ++ )
	{
		if ( ! isspace( (*str)[start] ) )
		{
			break;
		}
	}

	for ( end = str -> length() - 1  ;  end > start  ;  end -- )
	{
		if ( ! isspace( (*str)[end] ) )
		{
			break;
		}
	}

	*str = str -> substr( start , end - start + 1 );
}


static
int	compat_string_compare( const std::string &  str ,
			       std::string::size_type  pos ,
			       std::string::size_type  n ,
			       const std::string &  s )
{
#ifdef __GNUG__
#  if __GNUG__ <= 2
	return( str.compare( s , pos , n ) );
#  else
	return( str.compare( pos , n , s ) );
#  endif
#else
	return( str.compare( pos , n , s ) );
#endif
}


bool   starts_with( const std::string &  prefix ,  const std::string &  str )
{
	return( compat_string_compare
		( str , 0 , prefix.length() , prefix ) == 0 );
}

bool   ends_with( const std::string &  suffix ,  const std::string &  str )
{
	if ( str.length() < suffix.length() )
	{
		return( false );
	}

	return( compat_string_compare
		( str ,
		  str.length() - suffix.length() ,
		  suffix.length() ,
		  suffix ) == 0 );
}


std::string  toupper( const std::string &  str )
{
	std::string	ret;

	for ( size_t  i = 0  ;  i < str.size()  ;  i ++ )
	{
		ret += static_cast<unsigned char>
		       ( ::toupper( static_cast<unsigned char>(str[i]) ) );
	}

	return( ret );
}

std::string  tolower( const std::string &  str )
{
	std::string	ret;

	for ( size_t  i = 0  ;  i < str.size()  ;  i ++ )
	{
		ret += static_cast<unsigned char>
		       ( ::tolower( static_cast<unsigned char>(str[i]) ) );
	}

	return( ret );
}

std::string  capitalize_first( const std::string &  str )
{
	std::string	ret = str;

	if ( ! ret.empty() )
	{
		ret[0] = static_cast<unsigned char>( ::toupper( ret[0] ) );
	}

	return( ret );
}

std::string  replace( const std::string &  str ,
		      char  from_char ,
		      const std::string &  to_string )
{
	std::string	ret;

	for ( size_t  i = 0  ;  i < str.size()  ;  i ++ )
	{
		if ( str[i] == from_char )
		{
			ret += to_string;
		}
		else
		{
			ret += str[i];
		}
	}

	return( ret );
}


bool  unquote( std::string *  result ,  const std::string &  str )
{
	result -> erase();

	bool	in_quote = false;

	for( size_t  i = 0  ;  i < str.length()  ;  i ++ )
	{
		switch( str[i] )
		{
		case '"':
			in_quote = (! in_quote);
			break;

		default:
			(*result) += str[i];
			break;
		}
	}

	return( ! in_quote );
}


std::string  repeat_string( const std::string &  str ,  size_t  n )
{
	std::string	ret;

	for ( size_t  i = 0  ;  i < n  ;  i ++ )
	{
		ret += str;
	}

	return( ret );
}


} // end of namespace String_Extension
