#ifndef	   HEAP_STATUS_H_INCLUDED
#define	   HEAP_STATUS_H_INCLUDED

// Author:		H. Shimora
// Last-Modified:	Dec 16 1997
// Version:		0.10

//------------------------------------------------
// Change Log:
//------------------------------------------------
// version 0.10  Dec 16 1998	base version.
//
//

#ifdef HAVE_CONFIG_H
# include  "config.h"
#endif

#include  <new>
#include  <cstdio>
#include  <cstddef>

class  Heap_Status
{
private:
	friend	void *	operator new    ( size_t ) throw (std::bad_alloc);
	friend	void	operator delete ( void * ) throw();

	static	unsigned long	new_count;
	static	unsigned long	delete_count;

	struct Memory_Info
	{
		void *	memory;
		size_t	size;
	};

	static	Memory_Info *	pointer_list;
	static	size_t		n_pointer_list_entry;


public:
	class  Heap_Status_Initializer
	{
	public:
		Heap_Status_Initializer();
	};
	friend	class  Heap_Status_Initializer;

private:
	static	int	pointer_to_index( void *  pointer );

public:
	static	void	report( const char * str = NULL ,
				std::FILE *  fp = stderr );

	static	void	output_pointer_list();

	static	void	reset();

	static	unsigned long	n_new();
	static	unsigned long	n_delete();
	static	signed   long	new_delete_diff();
};


#endif	/* HEAP_STATUS_H_INCLUDED */
