#ifndef	   PROF_STOPWATCH_H_INCLUDED
#define	   PROF_STOPWATCH_H_INCLUDED

#ifdef HEVE_CONFIG_H
#    include  "config.h"
#endif

#include  <sys/types.h>
#include  "posix_compat_sys_time.h"

#ifdef HAVE_SYS_RESOURCE_H
#    if HAVE_SYS_RESOURCE_H
#	include  <sys/resource.h>
#    endif
#endif

#include  <iosfwd>
#include  <string>

#include  "time_stamp.h"


//
// Stopwatch Library for Profiling
//
class  Prof_Stopwatch
{
private:
	Time_Stamp	ts_start;
	Time_Stamp	ts_stop;

#ifdef HAVE_SYS_RESOURCE_H
	struct rusage	ru_start;
	struct rusage	ru_stop;
#endif

public:
	 Prof_Stopwatch();
	~Prof_Stopwatch();

	static	bool	valid();

	int	start();
	int	stop();

	Time_Stamp::Time_Diff	real() const;
	Time_Stamp::Time_Diff	user() const;
	Time_Stamp::Time_Diff	sys() const;

	void	print_with_indent
		( std::ostream &  ostrm ,
		  size_t  indent_level ,
		  const std::string &  indent_str = "\t" ) const;
};

extern std::ostream &  operator << ( std::ostream &  ostrm ,
				     const Prof_Stopwatch &  s );


#endif	/* PROF_STOPWATCH_H_INCLUDED */
