#ifndef	   SAMPLE_OPTION_ANALYZER_H_INCLUDED
#define	   SAMPLE_OPTION_ANALYZER_H_INCLUDED

// Author:		H. Shimora
// Last-Modified:	Jun  1 2000
// Created:		Jun  1 2000
// Version:		0.00

//------------------------------------------------
// Change Log:
//------------------------------------------------
// version 0.00  Jun  1 2000    base version.
//
//

#include  "option_analyzer.h"
#include  <string>
#include  <vector>

class  Sample_Option_Analyzer : public Option_Analyzer
{
protected:
	bool		help_;
	bool		flag_;
	int		integer_;
	double		float_;
	std::string	string_;

	std::vector<std::string>	raw_arguments_;

public:
	Sample_Option_Analyzer()
		: help_( false ) ,
		  flag_( false ) , integer_( 0 ) , float_( 0.0 ) , string_() ,
		  raw_arguments_()
	{
		add_option_flag_on    ( 'h' , "--help"        , &help_ );
		add_option_flag_on    ( 'f' , "--flag-on"     , &flag_ );
		add_option_flag_off   ( 'F' , "--flag-off"    , &flag_ );
		add_option_flag_toggle( 't' , "--flag-toggle" , &flag_ );
		add_option_integer    ( 'i' , "--integer"     , &integer_ );
		add_option_float      ( 'd' , "--float"       , &float_ );
		add_option_string     ( 's' , "--string"      , &string_ );

		add_long_option_raw_arguments( "--" , &raw_arguments_ );
	}

	virtual	~Sample_Option_Analyzer()
	{
	}

	virtual	void	usage( std::ostream *  ostr = &std::cerr ) const
	{
		(*ostr) << "Usage: "
		     << this -> program_name() << " [option ...]" << std::endl
		     << "Possible options are:" << std::endl
		     << "  -h, --help" << std::endl
		     << "  -f, --flag-on" << std::endl
		     << "  -F, --flag-off" << std::endl
		     << "  -t, --flag-toggle" << std::endl
		     << "  -i, --integer INTEGER" << std::endl
		     << "  -d, --float FLOAT" << std::endl
		     << "  -s, --string STRING" << std::endl;
	}

	virtual	bool	help() const
	{
		return( help_ );
	}

	virtual	bool	flag() const
	{
		return( flag_ );
	}

	virtual	int	integer() const
	{
		return( integer_ );
	}

	virtual	double	flt() const
	{
		return( float_ );
	}

	virtual	std::string	str() const
	{
		return( string_ );
	}

	std::vector<std::string>	raw_arguments() const
	{
		return( raw_arguments_ );
	}
};


#endif	/* SAMPLE_OPTION_ANALYZER_H_INCLUDED */
