#ifndef	   STREAMBUF_EXTENSION_H_INCLUDED
#define	   STREAMBUF_EXTENSION_H_INCLUDED

// Author:		H. Shimora
// Created:		Jan  7 2004
// Version:		0.00

///-----------------------------------------------
/// Change Log:
///-----------------------------------------------
// version 0.00  Jan  7 2004    base version.
//
//

#include  "streambuf_compat_wrapper.h"
#include  <cstddef>

class  streambuf_extension : public std::streambuf
{
protected:
	char *	input_buffer_begin() const
	{
		return( this -> std::streambuf::eback() );
	}

	char *	input_buffer_end() const
	{
		return( this -> std::streambuf::egptr() );
	}

	char *	input_buffer_current() const
	{
		return( this -> std::streambuf::gptr() );
	}

	void	input_buffer_move_current( int  n )
	{
		this -> std::streambuf::gbump( n );
	}

	char *	output_buffer_begin() const
	{
		return( this -> std::streambuf::pbase() );
	}

	char *	output_buffer_end() const
	{
		return( this -> std::streambuf::epptr() );
	}

	char *	output_buffer_current() const
	{
		return( this -> std::streambuf::pptr() );
	}

	void	output_buffer_move_current( int  n )
	{
		this -> std::streambuf::pbump( n );
	}


protected:
#if 0
	void	initialize_input_buffer( char *  buffer ,  size_t  size )
	{
		this -> std::streambuf::setg( buffer , buffer ,
					      buffer + size );
	}
#endif

	void	initialize_output_buffer( char *  buffer ,  size_t  size )
	{
		this -> std::streambuf::setp( buffer , buffer + size );
	}


	int	output_buffer_remain() const
	{
		return( this -> output_buffer_end()
			- this -> output_buffer_current() );
	}

	bool	output_buffer_full() const
	{
		return( this -> output_buffer_current()
			>= this -> output_buffer_end() );
	}

	bool	output_buffer_empty() const
	{
		return( this -> output_buffer_current()
			<= this -> output_buffer_begin() );
	}

	int	output_buffer_containing_bytes() const
	{
		return( this -> output_buffer_current()
			- this -> output_buffer_begin() );
	}

	int	input_buffer_remain() const
	{
		return( this -> input_buffer_end()
			- this -> input_buffer_current() );
	}
};


#endif	/* STREAMBUF_EXTENSION_H_INCLUDED */
