#include  "input_line_buffer.h"
#include  <iostream>


Input_Line_Buffer::Input_Line_Buffer( std::istream &  input )
	: input( input ) ,
	  have_newline( false ) ,
	  line()
{
}

Input_Line_Buffer::~Input_Line_Buffer()
{
}

bool   Input_Line_Buffer::line_completed() const
{
	while( const_cast<Input_Line_Buffer *>(this)
	       -> internal_read_char() )
	{
	}

	return( this -> have_newline );
}

bool   Input_Line_Buffer::eof() const
{
	return( this -> input.eof() );
}


void   Input_Line_Buffer::get_line( std::string *  result )
{
	std::string	ret = this -> line;
	this -> line = "";
	this -> have_newline = false;

	while( ret.size() > 0
	    && ( *(ret.rbegin()) == '\n'
	      || *(ret.rbegin()) == '\r' ) )
	{
		ret.erase( ret.size() - 1 );
	}

	*result = ret;
}

// private
bool   Input_Line_Buffer::internal_read_char()
{
	if ( this -> have_newline
	     || ! this -> input
	     || this -> eof() )
	{
		this -> have_newline = true;
		return( false );
	}

	unsigned char	ch = static_cast<unsigned char>( this -> input.get() );

	if ( ! this -> input || this -> eof() )
	{
		if ( ! this -> line.empty() )
		{
			this -> have_newline = true;
		}

		return( false );
	}

	this -> line += ch;

	if ( ch == '\n' )
	{
		this -> have_newline = true;
	}

	return( true );
}
