#include  "mkdir_mutex.h"
#include  "test_environment.h"


int    main( void )
{
	Test_Environment	t;

	{
		const	Path	LOCK_PATH( "test-lockdir" );

		Mkdir_Mutex	mutex1( LOCK_PATH );
		Mkdir_Mutex	mutex2( LOCK_PATH );

		bool	result_mutex1_lock     = mutex1.lock();
		t.Assert_Equals( true , result_mutex1_lock );

		bool	result_mutex1_try_lock = mutex2.trylock();
		t.Assert_Equals( false , result_mutex1_try_lock );

		bool	result_mutex1_unlock   = mutex1.unlock();
		t.Assert_Equals( true , result_mutex1_unlock );

		bool	result_mutex2_lock     = mutex2.lock();
		t.Assert_Equals( true , result_mutex2_lock );

		bool	result_mutex2_unlock   = mutex2.unlock();
		t.Assert_Equals( true , result_mutex2_unlock );
	}

	return( t.exit_status() );
}
