#ifndef	   D2_VECTOR_H_INCLUDED
#define	   D2_VECTOR_H_INCLUDED

// Author:		H. Shimora
// Last-Modified:	Apr  3 2000
// Version:		0.20

//------------------------------------------------
// Change Log:
//------------------------------------------------
// version 0.10  Jul 29 1998	base version.
//
// version 0.11  Mar 17 1999	some "const" added.
//
// version 0.20  Apr  3 2000	theta() returns Angle class
//
//

#ifdef HAVE_CONFIG_H
# include  "config.h"
#endif

#include  "angle.h"
#include  "float_traits.h"


//
//  D2_Vector
//
//    two dimentional mathmatical vector class.
//

class  D2_Vector
{
public:
	enum XY_or_Pole{ XY , Pole };

protected:
#if ! defined(D2_VECTOR_SIMPLE_IMPLEMENTATION)
	mutable	bool	xy_calculated;
	mutable	bool	pole_calculated;
#endif

	mutable	FLOAT	x_value;
	mutable	FLOAT	y_value;

#if ! defined(D2_VECTOR_SIMPLE_IMPLEMENTATION)
	mutable	FLOAT	r_value;
	mutable	FLOAT	theta_value;

	void	calculate_xy() const;
	void	calculate_pole() const;
#else
	void	get_pole_coordinate( FLOAT *  r_val ,
				     FLOAT *  theta_val ) const;
	void	set_xy_from_pole( FLOAT  r_val ,
				  FLOAT  theta_val ) const;
#endif

	void	divided_by_zero_notify() const;

	static	const FLOAT	EPSILON;


public:
	 D2_Vector();
	 D2_Vector( XY_or_Pole  type ,  FLOAT  x_or_r ,  FLOAT  y_or_theta );
	 D2_Vector( XY_or_Pole  type ,  FLOAT  r ,  const Angle &  theta );
	 D2_Vector( FLOAT  x ,  FLOAT  y );
	 D2_Vector( const D2_Vector &  vec );
	~D2_Vector();

	FLOAT	x() const;
	FLOAT	y() const;

	FLOAT	r() const;
	Angle	theta() const;


	D2_Vector	normalize() const;
	D2_Vector	normalize_theta() const;
	D2_Vector	rotate( const Angle &  d ) const;
	D2_Vector	reverse_x() const;
	D2_Vector	reverse_y() const;

	D2_Vector	operator + () const;
	D2_Vector	operator - () const;
	D2_Vector	operator + ( const D2_Vector &  vec ) const;
	D2_Vector	operator - ( const D2_Vector &  vec ) const;
	D2_Vector	operator * ( FLOAT  d ) const;
	D2_Vector	operator / ( FLOAT  d ) const;
	D2_Vector &	operator +=( const D2_Vector &  vec );
	D2_Vector &	operator -=( const D2_Vector &  vec );
	D2_Vector &	operator *=( FLOAT  d );
	D2_Vector &	operator /=( FLOAT  d );

	D2_Vector &	set( XY_or_Pole  type ,
			     FLOAT  x_or_r ,  FLOAT  y_or_theta );

	D2_Vector &	set( XY_or_Pole  type ,
			     FLOAT  r ,  const Angle &  theta );

	D2_Vector &	set( FLOAT  r ,  const Angle &  theta );

	D2_Vector &	set( FLOAT  x_val ,  FLOAT  y_val );

	D2_Vector &	set( const D2_Vector &  vec );

	D2_Vector &	set_x( FLOAT  x );
	D2_Vector &	set_y( FLOAT  y );
	D2_Vector &	set_r( FLOAT  r );
	D2_Vector &	set_theta( const Angle &  theta );

	bool		equal( const D2_Vector &  vec ,
			       FLOAT  epsiron = 0.0 ) const;

	D2_Vector &	operator = ( const D2_Vector &  vec );

	bool		operator == ( const D2_Vector &  vec ) const;
	bool		operator != ( const D2_Vector &  vec ) const;

	FLOAT	x_abs() const;
	FLOAT	y_abs() const;
	int	x_sign( int  zero_value = +1 ) const;
	int	y_sign( int  zero_value = +1 ) const;

	FLOAT	r_square() const;

	FLOAT	inner_product( const D2_Vector &  p ) const;


	static	D2_Vector	origin();

	static	FLOAT		eps();


public:
	class  Default_Comparator
	{
	public:
		bool	operator() ( const D2_Vector &  a ,
				     const D2_Vector &  b ) const
		{
			return( a.x() < b.x()
				|| (a.y() < b.y() && a.x() == b.x()) );
		}
	};
};


D2_Vector  operator * ( FLOAT  d ,  const D2_Vector &  vec );

#include  <iosfwd>
std::ostream &  operator << ( std::ostream &  ostr ,  const D2_Vector &  vec );

#define	D2_VECTOR_INLINE	inline
#if defined(D2_VECTOR_SIMPLE_IMPLEMENTATION)
#  include  "d2_vector_simple_inline.cc"
#else
#  include  "d2_vector_inline.cc"
#endif
#undef	D2_VECTOR_INLINE

#endif	/* D2_VECTOR_H_INCLUDED */
