#ifndef	   D2_SEGMENT_H_INCLUDED
#define	   D2_SEGMENT_H_INCLUDED

// Author:		H. Shimora
// Created:		Jul 30 2004
// Version:		0.00

///-----------------------------------------------
/// Change Log:
///-----------------------------------------------
// version 0.00  Jul 30 2004    base version.
//
//

#include  "d2_vector.h"
#include  "d2_straight_line.h"
#include  "float_traits.h"


class  D2_Segment
{
private:
	D2_Vector	p0;
	D2_Vector	p1;

private:
	bool	check_intersect_on_line( const D2_Vector &  p ) const;

public:
	D2_Segment( const D2_Vector &  p0 ,  const D2_Vector &  p1 );

	const D2_Vector &	point_0() const;
	const D2_Vector &	point_1() const;

	FLOAT	length() const;

	bool	intersect_without_terminal_point
			 ( const D2_Segment &  seg ) const;

	bool	intersect( const D2_Segment &  seg ) const;

	bool	on_segment( const D2_Vector &  p ) const;
	bool	on_segment( const D2_Vector &  p ,  FLOAT  max_dist ) const;

	FLOAT	distance( const D2_Vector &  p ) const;
	FLOAT	distance( const D2_Segment &  seg ) const;
	FLOAT	farthest_distance( const D2_Vector &  p ) const;

	D2_Vector		middle_point() const;
	D2_Vector		nearest_point( const D2_Vector &  p ) const;

	D2_Straight_Line	to_straight_line() const;

	D2_Segment		get_shift( const D2_Vector &  offset ) const;
};


#endif	/* D2_SEGMENT_H_INCLUDED */
