#include  "comstream.h"
#include  <iostream>
#include  <string>
#include  <vector>
#include  <cstdlib>

#include  "test_environment.h"

using namespace std;

int    main( void )
{
	Test_Environment	t;

	{
		std::vector<std::string> argv;
		argv.push_back( "grep" );
		argv.push_back( "^a" );

		// grep '^a' > test-file
		ocomstream	com( argv , "test-file" );

		if ( com )
		{
		    com << "abcdefg" << endl;
		    com << "abc" << endl;
		    com << "def" << endl;
		    com << "ghi" << endl;
		    com << "aaa" << endl;
		}
	}


	{
		string	buf;

		std::vector<std::string> argv;
		argv.push_back( "sed" );
		argv.push_back( "s/a/A/g" );

		// sed 's/a/A/g' < test-file
		icomstream	com( argv , "test-file" );

		for(;;)
		{
			string	line;

			getline( com , line );

			if ( ! com )
			{
				break;
			}

			cout << line << endl;

			buf += line;
			buf += '\n';
		}

		t.Assert_Equals( "Abcdefg\n"
				 "Abc\n"
				 "AAA\n" , buf );
	}


	return( t.exit_status() );
}
