#include  "compat_stringstream.h"
#include  "test_environment.h"
#include  <iostream>


int    main( void )
{
	Test_Environment	t;

	{
		compat_stringstream	s;

		s << 1 << "hello, world" << std::endl;

		t.Assert_Equals( "1hello, world\n" , s.str() );

		char	one = '\0';
		s >> one;

		t.Assert_Equals( '1' , one );
		t.Assert_Equals( "hello, world\n" , s.str() );


		std::string	hello;
		std::getline( s , hello );
		t.Assert_Equals( "hello, world" , hello );
	}


	{
		compat_istringstream	s( "3.14" );
		double	value = 0.0;
		s >> value;

		t.Assert_Nearly_Equals( 3.14 , value );
		t.Assert( s.str().empty() );
	}


	{
		compat_stringstream	s;
		s << 1.23;

		double	value = 0.0;
		s >> value;

		t.Assert_Nearly_Equals( 1.23 , value );
	}


	{
		compat_stringstream	s( "abc" );

		s << "d";
		t.Assert_Equals( "abcd" , s.str() );

		char	ch;
		s >> ch;

		t.Assert_Equals( 'a' , ch );

		t.Assert_Equals( "bcd" , s.str() );
	}


	{
		compat_istringstream	s( "1abc" );
		int	i = 0;

		s >> i;
		t.Assert_Equals( 1 , i );

		char	ch = '\0';
		s >> ch;
		t.Assert_Equals( 'a' , ch );

		t.Assert_Equals( "bc" , s.str() );
	}


	{
		compat_istringstream	s( "\xfe" );
		char	ch = '\0';

		s.get( ch );
		t.Assert( s );

		t.Assert_Equals( static_cast<char>(0xfe) , ch );
	}


	{
		compat_istringstream	s( "\xff" );
		char	ch = '\0';

		s.get( ch );
		t.Assert( s );

		t.Assert_Equals( static_cast<char>(0xff) , ch );
	}


	{
		compat_istringstream	s( "1abc" );
		int	i = 0;

		s >> i;
		t.Assert_Equals( 1 , i );

		t.Assert_Equals( "abc" , s.str() );
	}


	{
		compat_stringstream	s( "1abc" );
		int	i = 0;

		s >> i;
		t.Assert_Equals( 1 , i );

		t.Assert_Equals( "abc" , s.str() );

		s << "DEF";

		t.Assert_Equals( "abcDEF" , s.str() );

		s.clear();
		t.Assert_Equals( "" , s.str() );

		s << "2ghi";
		t.Assert_Equals( "2ghi" , s.str() );

		s >> i;
		t.Assert_Equals( 2 , i );
		t.Assert_Equals( "ghi" , s.str() );

		s.clear();
		t.Assert_Equals( "" , s.str() );
	}


	{
		compat_stringstream	s;

		const std::string	chars = "0123456789";
		const size_t		N = 10000;
		const std::string	newline = "\n";

		for ( size_t  i = 0  ;  i < chars.length()  ;  ++ i )
		{
			for ( size_t  n = 0  ;  n < N  ;  ++ n )
			{
				s << chars[i];
			}

			s << newline;
		}

		t.Assert_Equals( (N + newline.length()) * chars.length() ,
				 s.str().length() );
	}


	return( t.exit_status() );
}
