#include  "test_environment.h"
#include  "binary_writer.h"
#include  "compat_stringstream.h"


int    main( void )
{
	Test_Environment	t;

	{
		compat_stringstream	buf;

		Binary_Writer		w( buf );

		bool	result;
		result = w.write_2_bytes_unsigned_int_in_little_endian
							    ( 1 * 256 + 255 );

		t.Assert( result );
		t.Assert_Equals_Critical( size_t(2) , buf.str().size() );
		t.Assert_Equals( static_cast<unsigned char>( 255 ) ,
				 static_cast<unsigned char>( buf.str()[0] ) );
		t.Assert_Equals( static_cast<unsigned char>( 1 ) ,
				 static_cast<unsigned char>( buf.str()[1] ) );
	}


	{
		compat_stringstream	buf;

		Binary_Writer		w( buf );

		bool	result;
		result = w.write_2_bytes_signed_int_in_little_endian
						( static_cast<short>( -258 ) );

		t.Assert( result );
		t.Assert_Equals_Critical( size_t(2) , buf.str().size() );
		t.Assert_Equals( static_cast<unsigned char>( 254 ) ,
				 static_cast<unsigned char>( buf.str()[0] ) );
		t.Assert_Equals( static_cast<unsigned char>( 254 ) ,
				 static_cast<unsigned char>( buf.str()[1] ) );
	}

	{
		compat_stringstream	buf;

		Binary_Writer		w( buf );

		bool	result;
		result = w.write_4_bytes_unsigned_int_in_little_endian
						( static_cast<long>( 65537 ) );

		t.Assert( result );
		t.Assert_Equals_Critical( size_t(4) , buf.str().size() );
		t.Assert_Equals( static_cast<unsigned char>( 1 ) ,
				 static_cast<unsigned char>( buf.str()[0] ) );
		t.Assert_Equals( static_cast<unsigned char>( 0 ) ,
				 static_cast<unsigned char>( buf.str()[1] ) );
		t.Assert_Equals( static_cast<unsigned char>( 1 ) ,
				 static_cast<unsigned char>( buf.str()[2] ) );
		t.Assert_Equals( static_cast<unsigned char>( 0 ) ,
				 static_cast<unsigned char>( buf.str()[3] ) );
	}


	return( t.exit_status() );
}
