#include  "base64_encoder.h"
#include  "base64_decoder.h"
#include  <string>
#include  <cassert>
#include  <iostream>


int    main( void )
{
	const std::string	input = "hello world";

	std::string	in;

	for ( size_t  i = 0  ;  i < input.size()  ;  i ++ )
	{
		std::string	encoded;
		in += input[i];

		Base64_Encoder	encoder;

#ifdef TEST_DEBUG_PRINT
		std::cout << in << std::endl;
#endif

		encoder.encode( &encoded, in );

#ifdef TEST_DEBUG_PRINT
		std::cout << encoded << std::endl;
#endif


		Base64_Decoder	decoder;

		std::string	decoded;
		std::string	error_message;

		if ( ! decoder.decode( &decoded , encoded , &error_message ) )
		{
			std::cerr << "decode failure: " << error_message
				  << std::endl;

			return( 1 );
		}

#ifdef TEST_DEBUG_PRINT
		std::cout << decoded << std::endl;
#endif

		assert( in == decoded );

#ifdef TEST_DEBUG_PRINT
		std::cout << std::endl;
#endif
	}


	return( 0 );
}
